/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class BuiltStatement
extends RegularStatement {
    private static final Pattern lowercaseId = Pattern.compile("[a-z][a-z0-9_]*");
    private final List<ColumnMetadata> partitionKey;
    private final ByteBuffer[] routingKey;
    final String keyspace;
    private boolean dirty;
    private String cache;
    private List<Object> values;
    Boolean isCounterOp;
    boolean hasNonIdempotentOps;
    boolean hasBindMarkers;
    private boolean forceNoValues;

    BuiltStatement(String keyspace) {
        this.partitionKey = null;
        this.routingKey = null;
        this.keyspace = keyspace;
    }

    BuiltStatement(TableMetadata tableMetadata) {
        this.partitionKey = tableMetadata.getPartitionKey();
        this.routingKey = new ByteBuffer[tableMetadata.getPartitionKey().size()];
        this.keyspace = this.escapeId(tableMetadata.getKeyspace().getName());
    }

    protected String escapeId(String ident) {
        return lowercaseId.matcher(ident).matches() ? ident : Metadata.quote(ident);
    }

    @Override
    public String getQueryString() {
        this.maybeRebuildCache();
        return this.cache;
    }

    public Object getObject(int i) {
        this.maybeRebuildCache();
        if (this.values == null || this.values.isEmpty()) {
            throw new IllegalStateException("This statement does not have values");
        }
        if (i < 0 || i >= this.values.size()) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.values.get(i);
    }

    private void maybeRebuildCache() {
        StringBuilder sb;
        if (!this.dirty && this.cache != null) {
            return;
        }
        this.values = null;
        if (this.hasBindMarkers || this.forceNoValues) {
            sb = this.buildQueryString(null);
        } else {
            this.values = new ArrayList<Object>();
            sb = this.buildQueryString(this.values);
            if (this.values.size() > 65535) {
                throw new IllegalArgumentException("Too many values for built statement, the maximum allowed is 65535");
            }
            if (this.values.isEmpty()) {
                this.values = null;
            }
        }
        BuiltStatement.maybeAddSemicolon(sb);
        this.cache = sb.toString();
        this.dirty = false;
    }

    static StringBuilder maybeAddSemicolon(StringBuilder sb) {
        int l;
        for (l = sb.length(); l > 0 && sb.charAt(l - 1) <= ' '; --l) {
        }
        if (l != sb.length()) {
            sb.setLength(l);
        }
        if (l == 0 || sb.charAt(l - 1) != ';') {
            sb.append(';');
        }
        return sb;
    }

    abstract StringBuilder buildQueryString(List<Object> var1);

    boolean isCounterOp() {
        return this.isCounterOp == null ? false : this.isCounterOp;
    }

    void setCounterOp(boolean isCounterOp) {
        this.isCounterOp = isCounterOp;
    }

    boolean hasNonIdempotentOps() {
        return this.hasNonIdempotentOps;
    }

    void setNonIdempotentOps() {
        this.hasNonIdempotentOps = true;
    }

    void checkForBindMarkers(Object value) {
        this.dirty = true;
        if (Utils.containsBindMarker(value)) {
            this.hasBindMarkers = true;
        }
    }

    void checkForBindMarkers(Utils.Appendeable value) {
        this.dirty = true;
        if (value != null && value.containsBindMarker()) {
            this.hasBindMarkers = true;
        }
    }

    void maybeAddRoutingKey(String name, Object value) {
        if (this.routingKey == null || name == null || value == null || value instanceof BindMarker) {
            return;
        }
        for (int i = 0; i < this.partitionKey.size(); ++i) {
            if (!name.equals(this.partitionKey.get(i).getName()) || !Utils.isRawValue(value)) continue;
            DataType dt = this.partitionKey.get(i).getType();
            this.routingKey[i] = dt.serialize(dt.parse(Utils.toRawString(value)), ProtocolVersion.NEWEST_SUPPORTED);
            return;
        }
    }

    @Override
    public ByteBuffer getRoutingKey() {
        if (this.routingKey == null) {
            return null;
        }
        for (ByteBuffer bb : this.routingKey) {
            if (bb != null) continue;
            return null;
        }
        return this.routingKey.length == 1 ? this.routingKey[0] : BuiltStatement.compose(this.routingKey);
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    @Override
    public ByteBuffer[] getValues(ProtocolVersion protocolVersion) {
        this.maybeRebuildCache();
        return this.values == null ? null : Utils.convert(this.values, protocolVersion);
    }

    @Override
    public boolean hasValues() {
        this.maybeRebuildCache();
        return this.values != null;
    }

    @Override
    public Boolean isIdempotent() {
        if (this.idempotent != null) {
            return this.idempotent;
        }
        return !this.hasNonIdempotentOps();
    }

    @Override
    public String toString() {
        if (this.forceNoValues) {
            return this.getQueryString();
        }
        return BuiltStatement.maybeAddSemicolon(this.buildQueryString(null)).toString();
    }

    List<Object> getRawValues() {
        this.maybeRebuildCache();
        return this.values;
    }

    public RegularStatement setForceNoValues(boolean forceNoValues) {
        this.forceNoValues = forceNoValues;
        this.dirty = true;
        return this;
    }

    static ByteBuffer compose(ByteBuffer ... buffers) {
        int totalLength = 0;
        for (ByteBuffer bb : buffers) {
            totalLength += 2 + bb.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        for (ByteBuffer buffer : buffers) {
            ByteBuffer bb = buffer.duplicate();
            BuiltStatement.putShortLength(out, bb.remaining());
            out.put(bb);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    private static void putShortLength(ByteBuffer bb, int length) {
        bb.put((byte)(length >> 8 & 0xFF));
        bb.put((byte)(length & 0xFF));
    }

    static abstract class ForwardingStatement<T extends BuiltStatement>
    extends BuiltStatement {
        T statement;

        ForwardingStatement(T statement) {
            super((String)null);
            this.statement = statement;
        }

        @Override
        public String getQueryString() {
            return ((BuiltStatement)this.statement).getQueryString();
        }

        @Override
        StringBuilder buildQueryString(List<Object> values) {
            return ((BuiltStatement)this.statement).buildQueryString(values);
        }

        @Override
        public ByteBuffer getRoutingKey() {
            return ((BuiltStatement)this.statement).getRoutingKey();
        }

        @Override
        public String getKeyspace() {
            return ((BuiltStatement)this.statement).getKeyspace();
        }

        @Override
        boolean isCounterOp() {
            return ((BuiltStatement)this.statement).isCounterOp();
        }

        @Override
        boolean hasNonIdempotentOps() {
            return ((BuiltStatement)this.statement).hasNonIdempotentOps();
        }

        @Override
        public RegularStatement setForceNoValues(boolean forceNoValues) {
            ((BuiltStatement)this.statement).setForceNoValues(forceNoValues);
            return this;
        }

        @Override
        List<Object> getRawValues() {
            return ((BuiltStatement)this.statement).getRawValues();
        }

        @Override
        public Statement setConsistencyLevel(ConsistencyLevel consistency) {
            ((Statement)this.statement).setConsistencyLevel(consistency);
            return this;
        }

        @Override
        public ConsistencyLevel getConsistencyLevel() {
            return ((Statement)this.statement).getConsistencyLevel();
        }

        @Override
        public Statement enableTracing() {
            ((Statement)this.statement).enableTracing();
            return this;
        }

        @Override
        public Statement disableTracing() {
            ((Statement)this.statement).disableTracing();
            return this;
        }

        @Override
        public boolean isTracing() {
            return ((Statement)this.statement).isTracing();
        }

        @Override
        public Statement setRetryPolicy(RetryPolicy policy) {
            ((Statement)this.statement).setRetryPolicy(policy);
            return this;
        }

        @Override
        public RetryPolicy getRetryPolicy() {
            return ((Statement)this.statement).getRetryPolicy();
        }

        @Override
        public ByteBuffer[] getValues(ProtocolVersion protocolVersion) {
            return ((BuiltStatement)this.statement).getValues(protocolVersion);
        }

        @Override
        public boolean hasValues() {
            return ((BuiltStatement)this.statement).hasValues();
        }

        @Override
        void checkForBindMarkers(Object value) {
            ((BuiltStatement)this.statement).checkForBindMarkers(value);
        }

        @Override
        void checkForBindMarkers(Utils.Appendeable value) {
            ((BuiltStatement)this.statement).checkForBindMarkers(value);
        }

        @Override
        public String toString() {
            return ((BuiltStatement)this.statement).toString();
        }
    }
}

