/*
 * Copyright 2015 Ryan Svihla
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pro.foundev.cassandra.commons.migrations.cmd.arguments;

import pro.foundev.cassandra.commons.core.CassandraConfiguration;

/**
 * Adds a command argument to the CassandraConfiguration
 */
public class MigrationConfiguration extends CassandraConfiguration{
    private String command;
    private String scriptDirectory;

    public String getCommand() {
        return command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setScriptDirectory(String scriptDirectory) {
        this.scriptDirectory = scriptDirectory;
    }

    public String getScriptDirectory() {

        return scriptDirectory;
    }

    @Override
    public String toString(){
        String hosts = "";
        if(getHosts()!=null){
            hosts = String.join(",", getHosts());
        }
        String port = "";
        if(getPort()!=null){
            port = String.valueOf(getPort());
        }
         return String.format("command: %s, keyspace: %s, " +
                         "script directory: %s," +
                         " hosts: %s, " +
                         "port: %s, " +
                         "user: %s, " +
                         "pass: %s",
                 orEmptyString(command),
                 orEmptyString(getKeyspace()),
                 orEmptyString(getScriptDirectory()),
                 hosts,
                 port,
                 orEmptyString(getUsername()),
                 orEmptyString(getPassword()));

    }

    private String orEmptyString(String original){
        if(original!=null){
            return original;
        }
        return "";
    }

}
