/*
 * Copyright 2015 Ryan Svihla
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pro.foundev.cassandra.commons.migrations.cmd;


import pro.foundev.cassandra.commons.migrations.MigrationRunner;
import pro.foundev.cassandra.commons.migrations.MigrationRunnerImpl;
import pro.foundev.cassandra.commons.migrations.cmd.arguments.CommandLineArgumentsParser;
import pro.foundev.cassandra.commons.migrations.cmd.arguments.MigrationConfiguration;

import java.io.FileNotFoundException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;

/**
 * Very simple migration runner that launches
 */
public class MigrationCmdLine {
    private static MigrationRunner runner;
    /**
     * Main method that launches the class
     * @param args first argument is keyspace, second is script directory and optional
     */
    public static void main(String[] args) throws FileNotFoundException {
        final CommandLineArgumentsParser parser = new CommandLineArgumentsParser();
        MigrationConfiguration configuration = parser.parse(args);
        String scriptDirectory = configuration.getScriptDirectory();
        runner = new MigrationRunnerImpl(configuration);
        System.out.println("running " + configuration);
        String command = configuration.getCommand();
        if("migrate".equals(command)) {
            migrate(scriptDirectory);
        }else if("reset".equals(command)) {
            runner.resetKeyspace();
            migrate(scriptDirectory);
        }
    }

    private static void migrate(String scriptDirectory) throws FileNotFoundException {
        FileSystem fs = FileSystems.getDefault();
        runner.runScriptDirectory(fs.getPath(scriptDirectory));
    }
}
