/*
 * Copyright 2015 Ryan Svihla
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pro.foundev.cassandra.commons.maven;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import pro.foundev.cassandra.commons.maven.loader.MojoMigrationLoader;
import pro.foundev.cassandra.commons.maven.loader.MojoMigrationLoaderImpl;

@Mojo(name="migrate")
public class MigrationsMojo extends AbstractMojo {
    @Parameter
    private String scriptDirectory;
    @Parameter
    private String yamlFileLocation;
    private MojoMigrationLoader mojoMigrationLoader = new MojoMigrationLoaderImpl();

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        getLog().info("starting migration configuration check");
        try {
            mojoMigrationLoader.exec(scriptDirectory, yamlFileLocation);
        }catch (Exception e) {
            throw new MojoFailureException(e, "migrations failed", "Unable to complete migrations please review the" +
                    "error logged");
        }
    }

    public void setScriptDirectory(String scriptDirectory) {
        this.scriptDirectory = scriptDirectory;
    }

    public void setYamlFileLocation(String yamlFileLocation) {
        this.yamlFileLocation = yamlFileLocation;
    }

    public void setMojoMigrationLoader(MojoMigrationLoader mojoMigrationLoader) {
        this.mojoMigrationLoader = mojoMigrationLoader;
    }
}
