/*
 * Decompiled with CFR 0.152.
 */
package pro.foundev.cassandra.commons.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import java.util.List;
import pro.foundev.cassandra.commons.core.CassandraConfiguration;

public class CassandraSessionFactory {
    private final Cluster cluster;
    private final Session session;

    public Session getSession() {
        return this.session;
    }

    public CassandraSessionFactory(CassandraConfiguration config) {
        List<String> hosts = config.getHosts();
        String[] hostArray = new String[hosts.size()];
        hosts.toArray(hostArray);
        Cluster.Builder builder = Cluster.builder().addContactPoints(hostArray).withPort(config.getPort().intValue());
        if (config.hasCreds()) {
            builder.withCredentials(config.getUsername(), config.getPassword());
        }
        this.cluster = builder.build();
        this.session = this.cluster.newSession();
        String keyspace = config.getKeyspace();
        Row row = this.session.execute("SELECT * FROM system.schema_keyspaces WHERE keyspace_name='" + keyspace + "'").one();
        if (row == null) {
            this.session.execute("CREATE KEYSPACE " + keyspace + " WITH REPLICATION = { 'class':'SimpleStrategy'," + "'replication_factor':1}");
        }
        this.session.execute("USE " + keyspace);
    }

    public void close() {
        if (this.session != null) {
            this.session.close();
        }
        if (this.cluster != null) {
            this.cluster.close();
        }
    }
}

