/*
 * Decompiled with CFR 0.152.
 */
package pro.foundev.cassandra.commons.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class CassandraConfiguration {
    private String password;
    private String username;
    private String keyspace;
    private Integer port;
    private List<String> hosts;

    public static CassandraConfiguration parse(String yamlFilePath) {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(CassandraConfiguration.class));
        InputStream input = null;
        try {
            input = new FileInputStream(new File(yamlFilePath));
            CassandraConfiguration cassandraConfiguration = (CassandraConfiguration)yaml.load(input);
            return cassandraConfiguration;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    public boolean hasCreds() {
        return this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }
}

