/*
 * Copyright 2015 Ryan Svihla
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pro.foundev.cassandra.commons.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;

import java.util.List;

public class CassandraSessionFactory {
    private final Cluster cluster;
    private final Session session;

    public Session getSession() {
        return session;
    }

    /**
     * FIXME: TESTS
     *
     */
    public CassandraSessionFactory(CassandraConfiguration config) {
        List<String> hosts = config.getHosts();
        String[] hostArray = new String[hosts.size()];
        hosts.toArray(hostArray);
        Cluster.Builder builder = Cluster.builder()
                .addContactPoints(hostArray)
                .withPort(config.getPort());
        if (config.hasCreds()) {
            builder.withCredentials(config.getUsername(), config.getPassword());
        }
        cluster = builder.build();
        session = cluster.newSession();
        String keyspace = config.getKeyspace();
        Row row = session.execute("SELECT * FROM system.schema_keyspaces WHERE keyspace_name='"
                + keyspace + "'").one();
        if (row == null) {
            //must search for keyspace in case there is minimal rights available to user
            session.execute("CREATE KEYSPACE " + keyspace + " WITH REPLICATION = { 'class':'SimpleStrategy'," +
                    "'replication_factor':1}");
        }
        session.execute("USE " + keyspace);
    }


    /**
     * must call after you're done with the class or resources will not get cleaned up
     */
    public void close(){
        if(session!=null){
            session.close();
        }
        if(cluster!=null) {
            cluster.close();
        }
    }


}
