/*
 * Copyright 2015 Ryan Svihla
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pro.foundev.cassandra.commons.core;

import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class CassandraConfiguration {
    private String password;
    private String username;
    private String keyspace;
    private Integer port;
    private List<String> hosts;

    /**
     *
     * @param yamlFilePath yaml file to load in the following format
     *                 keyspace: my_keyspace
     *                 username: cassandra
     *                 password: casspw
     *                 port: 9042
     *                 hosts:
     *                   - 127.0.0.1
     *                   - 127.0.0.2
     * @return hydrated cassandra configuration object
     */
    public static CassandraConfiguration parse(String yamlFilePath){
        Yaml yaml = new Yaml(new Constructor(CassandraConfiguration.class));
        InputStream input = null;
        try {
            input = new FileInputStream(new File(yamlFilePath));
            return (CassandraConfiguration)yaml.load(input);
        } catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);

        }finally{
            if(input!=null){
                try {
                    input.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    public boolean hasCreds() {
        return username!=null && !username.isEmpty() && password!=null && !password.isEmpty();
    }

    public String getUsername() {
        return username;
    }

    public String getPassword() {
        return password;
    }

    public List<String> getHosts() {
        return hosts;
    }

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public String getKeyspace() {
        return keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }
}
