/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.webmvc.AutoRegisterInterceptor;
import pro.fessional.wings.slardar.webmvc.PageQueryArgumentResolver;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class SlardarWebMvcConfiguration
implements WebMvcConfigurer {
    private static final Log log = LogFactory.getLog(SlardarWebMvcConfiguration.class);
    private final List<AutoRegisterInterceptor> interceptors;
    private final PageQueryArgumentResolver pageQueryArgumentResolver;
    private final AsyncTaskExecutor applicationTaskExecutor;

    public SlardarWebMvcConfiguration(List<AutoRegisterInterceptor> interceptors, @Autowired(required=false) PageQueryArgumentResolver pageQueryArgumentResolver, @Qualifier(value="applicationTaskExecutor") @Autowired(required=false) AsyncTaskExecutor applicationTaskExecutor) {
        this.interceptors = interceptors;
        this.pageQueryArgumentResolver = pageQueryArgumentResolver;
        this.applicationTaskExecutor = applicationTaskExecutor;
    }

    public void addInterceptors(@NotNull InterceptorRegistry registry) {
        for (AutoRegisterInterceptor it : this.interceptors) {
            List<String> ie;
            log.info((Object)("SlardarWebmvc conf Interceptor=" + it.getClass().getName()));
            InterceptorRegistration ir = registry.addInterceptor((HandlerInterceptor)it);
            ir.order(it.getOrder());
            List<String> ic = it.getIncludePatterns();
            if (!ic.isEmpty()) {
                ir.addPathPatterns(ic);
            }
            if ((ie = it.getExcludePatterns()).isEmpty()) continue;
            ir.excludePathPatterns(ie);
        }
    }

    public void addArgumentResolvers(@NotNull List<HandlerMethodArgumentResolver> resolvers) {
        if (this.pageQueryArgumentResolver != null) {
            log.info((Object)("SlardarWebmvc conf HandlerMethodArgumentResolver=" + this.pageQueryArgumentResolver.getClass().getName()));
            resolvers.add(this.pageQueryArgumentResolver);
        }
    }

    public void configureAsyncSupport(@NotNull AsyncSupportConfigurer configurer) {
        if (this.applicationTaskExecutor != null) {
            configurer.setTaskExecutor(this.applicationTaskExecutor);
        }
    }
}

