/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.concur.impl.RighterExceptionResolver;
import pro.fessional.wings.slardar.concur.impl.RighterInterceptor;
import pro.fessional.wings.slardar.spring.prop.SlardarRighterProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled(abs="wings.enabled.slardar.righter")
public class SlardarRighterConfiguration {
    private static final Log log = LogFactory.getLog(SlardarRighterConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public RighterExceptionResolver righterExceptionResolver(SlardarRighterProp prop) {
        log.info((Object)"SlardarWebmvc spring-bean righterExceptionResolver");
        return new RighterExceptionResolver(prop);
    }

    @Bean
    @ConditionalWingsEnabled
    public RighterInterceptor righterInterceptor(ObjectProvider<RighterInterceptor.SecretProvider> secretProvider, SlardarRighterProp prop) {
        log.info((Object)"SlardarWebmvc spring-bean righterInterceptor");
        RighterInterceptor bean = new RighterInterceptor(prop);
        secretProvider.ifAvailable(bean::setSecretProvider);
        return bean;
    }
}

