/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.security.pass;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.crypto.argon2.Argon2PasswordEncoder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.LdapShaPasswordEncoder;
import org.springframework.security.crypto.password.Md4PasswordEncoder;
import org.springframework.security.crypto.password.MessageDigestPasswordEncoder;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.crypto.password.StandardPasswordEncoder;
import org.springframework.security.crypto.scrypt.SCryptPasswordEncoder;
import pro.fessional.wings.slardar.security.pass.BasicPasswordEncoder;
import pro.fessional.wings.slardar.security.pass.HashPasswordEncoder;
import pro.fessional.wings.slardar.security.pass.MysqlPasswordEncoder;
import pro.fessional.wings.slardar.security.pass.NeverPasswordEncoder;

public class PasswordEncoders {
    public static final String Noop = "noop";
    public static final String Never = "never";
    public static final String Basic = "basic";
    public static final String NoopMd5 = "noop-md5";
    public static final String NoopSha1 = "noop-sha1";
    public static final String NoopSha256 = "noop-sha256";
    public static final String Bcrypt = "bcrypt";
    public static final String Pbkdf2 = "pbkdf2";
    public static final String Scrypt = "scrypt";
    public static final String Argon2 = "argon2";
    public static final String Ldap = "ldap";
    public static final String Md4 = "MD4";
    public static final String Md5 = "MD5";
    public static final String Pbkdf2V58 = "pbkdf2-58";
    public static final String ScryptV58 = "scrypt-58";
    public static final String Sha1 = "SHA-1";
    public static final String Sha256 = "SHA-256";
    public static final String Argon2V58 = "argon2-58";
    public static final String Sha256s = "sha256";
    public static final String Mysql = "mysql";
    private static final Map<String, PasswordEncoder> encoderMap = new HashMap<String, PasswordEncoder>();

    @NotNull
    public static Map<String, PasswordEncoder> getEncoders() {
        return encoderMap;
    }

    @Nullable
    public static PasswordEncoder getEncoder(String encoder) {
        return encoderMap.get(encoder);
    }

    @Nullable
    public static String encode(String encoder, CharSequence password) {
        PasswordEncoder enc = encoderMap.get(encoder);
        return enc == null ? null : enc.encode(password);
    }

    @Nullable
    public static String delegating(String encoder, CharSequence password) {
        if (encoder == null || password == null) {
            return null;
        }
        PasswordEncoder enc = encoderMap.get(encoder);
        if (enc == null) {
            return null;
        }
        if (Never.equalsIgnoreCase(encoder)) {
            return enc.encode(password);
        }
        return "{" + encoder + "}" + enc.encode(password);
    }

    @Contract(value="!null, _ -> !null")
    public static String delegated(String password, String encoder) {
        if (password == null) {
            return null;
        }
        int bc = password.indexOf("}", 2);
        if (password.startsWith("{") && bc > 0) {
            return password;
        }
        String pw = PasswordEncoders.delegating(encoder, password);
        return pw == null ? "{noop-md5}" + password : pw;
    }

    @NotNull
    public static Map<String, PasswordEncoder> initEncoders(long basicMs) {
        encoderMap.put(Noop, NoOpPasswordEncoder.getInstance());
        encoderMap.put(Never, new NeverPasswordEncoder(Never));
        encoderMap.put(Basic, new BasicPasswordEncoder(basicMs));
        encoderMap.put(NoopMd5, HashPasswordEncoder.md5());
        encoderMap.put(NoopSha1, HashPasswordEncoder.sha1());
        encoderMap.put(NoopSha256, HashPasswordEncoder.sha256());
        encoderMap.put(Bcrypt, (PasswordEncoder)new BCryptPasswordEncoder());
        encoderMap.put(Pbkdf2, (PasswordEncoder)Pbkdf2PasswordEncoder.defaultsForSpringSecurity_v5_5());
        encoderMap.put(Scrypt, (PasswordEncoder)SCryptPasswordEncoder.defaultsForSpringSecurity_v4_1());
        encoderMap.put(Argon2, (PasswordEncoder)Argon2PasswordEncoder.defaultsForSpringSecurity_v5_2());
        encoderMap.put(Ldap, (PasswordEncoder)new LdapShaPasswordEncoder());
        encoderMap.put(Md4, (PasswordEncoder)new Md4PasswordEncoder());
        encoderMap.put(Md5, (PasswordEncoder)new MessageDigestPasswordEncoder(Md5));
        encoderMap.put(Pbkdf2V58, (PasswordEncoder)Pbkdf2PasswordEncoder.defaultsForSpringSecurity_v5_8());
        encoderMap.put(ScryptV58, (PasswordEncoder)SCryptPasswordEncoder.defaultsForSpringSecurity_v5_8());
        encoderMap.put(Sha1, (PasswordEncoder)new MessageDigestPasswordEncoder(Sha1));
        encoderMap.put(Sha256, (PasswordEncoder)new MessageDigestPasswordEncoder(Sha256));
        encoderMap.put(Sha256s, (PasswordEncoder)new StandardPasswordEncoder());
        encoderMap.put(Argon2V58, (PasswordEncoder)Argon2PasswordEncoder.defaultsForSpringSecurity_v5_8());
        encoderMap.put(Mysql, new MysqlPasswordEncoder());
        return encoderMap;
    }
}

