/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.security.pass;

import org.springframework.security.crypto.password.PasswordEncoder;
import pro.fessional.mirana.bits.MdHelp;

public class HashPasswordEncoder
implements PasswordEncoder {
    private final MdHelp helper;

    public HashPasswordEncoder(String algorithm) {
        this.helper = MdHelp.of((String)algorithm);
    }

    public static HashPasswordEncoder md5() {
        return new HashPasswordEncoder("MD5");
    }

    public static HashPasswordEncoder sha1() {
        return new HashPasswordEncoder("SHA-1");
    }

    public static HashPasswordEncoder sha256() {
        return new HashPasswordEncoder("SHA-256");
    }

    public String encode(CharSequence rawPassword) {
        return rawPassword.toString();
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        if (rawPassword.equals(encodedPassword)) {
            return true;
        }
        String hash = this.hash(encodedPassword);
        return hash.equalsIgnoreCase(rawPassword.toString());
    }

    public String hash(String plain) {
        return this.helper.sum(plain, false);
    }
}

