/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.security.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.server.PathContainer;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import pro.fessional.wings.slardar.security.WingsAuthHelper;
import pro.fessional.wings.slardar.security.WingsAuthTypeParser;
import pro.fessional.wings.slardar.security.WingsAuthTypeSource;

public class DefaultWingsAuthTypeSource
implements WingsAuthTypeSource {
    private final String pathPattern;
    private final WingsAuthTypeParser typeParser;
    private final boolean hasTypePath;
    private final boolean hasZonePath;

    public DefaultWingsAuthTypeSource(String pathPattern, WingsAuthTypeParser typeParser) {
        this.pathPattern = pathPattern;
        this.typeParser = typeParser;
        this.hasTypePath = pathPattern.contains("authType");
        this.hasZonePath = pathPattern.contains("authZone");
    }

    @Override
    @NotNull
    public Enum<?> buildAuthType(HttpServletRequest request) {
        PathPattern parse;
        PathPattern.PathMatchInfo info;
        String type = null;
        String zone = null;
        if ((this.hasTypePath || this.hasZonePath) && (info = (parse = PathPatternParser.defaultInstance.parse(this.pathPattern)).matchAndExtract(PathContainer.parsePath((String)request.getRequestURI()))) != null) {
            Map mp = info.getUriVariables();
            type = (String)mp.get("authType");
            zone = (String)mp.get("authZone");
        }
        if (type == null || type.isEmpty()) {
            type = request.getParameter("authType");
        }
        if (zone == null || zone.isEmpty()) {
            zone = request.getParameter("authZone");
        }
        Enum<?> enu = this.typeParser.parse(type);
        WingsAuthHelper.setAuthTypeAttribute(request, enu);
        WingsAuthHelper.setAuthZoneAttribute(request, zone);
        return enu;
    }
}

