/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.security.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import pro.fessional.mirana.func.Dcl;
import pro.fessional.wings.slardar.security.WingsAuthPageHandler;
import pro.fessional.wings.slardar.servlet.request.RequestHelper;

public class ComboWingsAuthPageHandler
implements WingsAuthPageHandler {
    private final List<Combo> combos = new ArrayList<Combo>();
    private final Dcl<Void> dclCombos = Dcl.of(() -> this.combos.sort(Comparator.comparingInt(Ordered::getOrder)));
    private final ResponseEntity<?> NOT_FOUND = ResponseEntity.notFound().build();

    @Override
    public ResponseEntity<?> response(@NotNull Enum<?> authType, @Nullable MediaType mediaType, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        this.dclCombos.runIfDirty();
        if (mediaType == null) {
            try {
                mediaType = MediaType.valueOf((String)request.getContentType());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        HttpStatus status = RequestHelper.isForwarding(request) ? HttpStatus.UNAUTHORIZED : HttpStatus.OK;
        for (Combo combo : this.combos) {
            ResponseEntity<?> res = combo.response(authType, mediaType, request, response, status);
            if (res == null) continue;
            return res;
        }
        return this.NOT_FOUND;
    }

    public void add(Combo source) {
        if (source == null) {
            return;
        }
        this.combos.add(source);
        this.dclCombos.setDirty();
    }

    public void addAll(Collection<? extends Combo> source) {
        if (source == null) {
            return;
        }
        this.combos.addAll(source);
        this.dclCombos.setDirty();
    }

    public static interface Combo
    extends Ordered {
        public ResponseEntity<?> response(@NotNull Enum<?> var1, @Nullable MediaType var2, @NotNull HttpServletRequest var3, @NotNull HttpServletResponse var4, @NotNull HttpStatus var5);
    }
}

