/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.security.bind;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.util.Assert;
import pro.fessional.wings.slardar.security.WingsAuthDetailsSource;
import pro.fessional.wings.slardar.security.WingsAuthTypeSource;
import pro.fessional.wings.slardar.security.bind.WingsBindAuthToken;

public class WingsBindAuthFilter
extends UsernamePasswordAuthenticationFilter {
    protected WingsAuthTypeSource wingsAuthTypeSource;

    public WingsBindAuthFilter() {
        this.setPostOnly(false);
    }

    public WingsBindAuthFilter(AuthenticationManager authenticationManager) {
        super(authenticationManager);
        this.setPostOnly(false);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.wingsAuthTypeSource, (String)"wingsBindAuthTypeSource must be specified. should expose a Bean by type or manual config");
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        String username = this.obtainUsername(request);
        username = username != null ? username.trim() : "";
        String password = this.obtainPassword(request);
        password = password != null ? password : "";
        Enum<?> authType = this.wingsAuthTypeSource.buildAuthType(request);
        WingsBindAuthToken winTkn = new WingsBindAuthToken(authType, username, password);
        Object details = this.buildAuthDetails(request, winTkn);
        winTkn.setDetails(details);
        return this.getAuthenticationManager().authenticate((Authentication)winTkn);
    }

    protected Object buildAuthDetails(HttpServletRequest request, WingsBindAuthToken winTkn) {
        AuthenticationDetailsSource authenticationDetailsSource = this.authenticationDetailsSource;
        if (authenticationDetailsSource instanceof WingsAuthDetailsSource) {
            WingsAuthDetailsSource winAds = (WingsAuthDetailsSource)authenticationDetailsSource;
            return winAds.buildDetails(winTkn.getAuthType(), request);
        }
        return this.authenticationDetailsSource.buildDetails((Object)request);
    }

    public WingsAuthTypeSource getWingsBindAuthTypeSource() {
        return this.wingsAuthTypeSource;
    }

    public void setWingsBindAuthTypeSource(WingsAuthTypeSource wingsAuthTypeSource) {
        Assert.notNull((Object)wingsAuthTypeSource, (String)"wingsBindAuthTypeSource required");
        this.wingsAuthTypeSource = wingsAuthTypeSource;
    }
}

