/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.domainx;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;

public class DomainRequestWrapper
extends HttpServletRequestWrapper {
    private String oldRequestUri = null;
    private String newRequestUri = null;

    public DomainRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public void setRequestURI(String str) {
        if (str == null) {
            this.oldRequestUri = null;
            this.newRequestUri = null;
        } else {
            this.oldRequestUri = super.getRequestURI();
            this.newRequestUri = str;
        }
    }

    public String getRequestURI() {
        return this.newRequestUri == null ? super.getRequestURI() : this.newRequestUri;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = super.getRequestURL();
        if (this.newRequestUri != null) {
            url.replace(0, this.oldRequestUri.length(), this.newRequestUri);
        }
        return url;
    }

    public String getServletPath() {
        String url = super.getServletPath();
        if (this.newRequestUri != null && !url.isEmpty()) {
            url = url.replace(this.oldRequestUri, this.newRequestUri);
        }
        return url;
    }
}

