/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.text.HalfCharUtil;

public class DateParser {
    private DateParser() {
    }

    @NotNull
    public static LocalTime parseTime(@NotNull String num) {
        return DateParser.parseTime(num, 0);
    }

    @NotNull
    public static LocalDate parseDate(@NotNull String num) {
        return DateParser.parseDate(num, 0);
    }

    @NotNull
    public static LocalDateTime parseDateTime(@NotNull String num) {
        return DateParser.parseDateTime(num, 0);
    }

    @NotNull
    public static LocalTime parseTime(@NotNull CharSequence str, int off) {
        String num = DateParser.digit(str, off, Ptn.TIME);
        int len = num.length();
        if (len != 6 && len != 9) {
            throw new IllegalArgumentException("only support time6,time9 format");
        }
        return DateParser.time(num, 0);
    }

    @NotNull
    public static LocalDate parseDate(@NotNull CharSequence str, int off) {
        String num = DateParser.digit(str, off, Ptn.DATE);
        int len = num.length();
        if (len != 8) {
            throw new IllegalArgumentException("only support date8 format");
        }
        return DateParser.date(num);
    }

    @NotNull
    public static LocalDateTime parseDateTime(@NotNull CharSequence str, int off) {
        String num = DateParser.digit(str, off, Ptn.FULL);
        int len = num.length();
        if (len != 14 && len != 17) {
            throw new IllegalArgumentException("only support datetime14,datetime17 format");
        }
        LocalDate ld = DateParser.date(num);
        LocalTime lt = DateParser.time(num, 8);
        return LocalDateTime.of(ld, lt);
    }

    @NotNull
    public static String digit(@Nullable CharSequence str, int off, Ptn ptn) {
        int i;
        if (str == null) {
            return "";
        }
        int idx = 0;
        StringBuilder[] buff = new StringBuilder[ptn.pad.length];
        buff[idx] = new StringBuilder(ptn.len);
        int cnt = 0;
        int nan = 0;
        int len = str.length();
        for (i = 0; i < len; ++i) {
            char c = HalfCharUtil.half(str.charAt(i));
            if (c >= '0' && c <= '9') {
                if (++cnt <= off) continue;
                buff[idx].append(c);
                nan = 1;
                continue;
            }
            if (nan != true || idx >= ptn.pad.length - 1) continue;
            buff[++idx] = new StringBuilder(ptn.len);
            nan = 2;
        }
        if (ptn != Ptn.TIME && idx >= 2 && buff[1].length() <= 2 && DateParser.isMonth(buff[0]) && !DateParser.isMonth(buff[2])) {
            StringBuilder tp = buff[2];
            buff[2] = buff[1];
            buff[1] = buff[0];
            buff[0] = tp;
        }
        for (i = 0; i < ptn.pad.length; ++i) {
            if (i <= idx) {
                int sln;
                int cln = buff[i].length();
                if (cln == (sln = ptn.pad[i].length())) continue;
                if (cln > sln) break;
                boolean az = true;
                for (int j = 0; j < cln; ++j) {
                    if (buff[i].charAt(j) == '0') continue;
                    az = false;
                    break;
                }
                if (az) {
                    buff[i].replace(0, cln, ptn.pad[i]);
                    continue;
                }
                buff[i].insert(0, ptn.pad[i], 0, sln - cln);
                continue;
            }
            buff[idx].append(ptn.pad[i]);
        }
        StringBuilder sb = buff[0];
        for (int i2 = 1; i2 <= idx; ++i2) {
            sb.append((CharSequence)buff[i2]);
        }
        return sb.length() <= ptn.len ? sb.toString() : sb.substring(0, ptn.len);
    }

    private static boolean isMonth(CharSequence str) {
        int len = str.length();
        if (len == 1) {
            char c = str.charAt(0);
            return c >= '1' && c <= '9';
        }
        if (len == 2) {
            char c1 = str.charAt(0);
            char c2 = str.charAt(1);
            if (c1 == '0' && c2 >= '1' && c2 <= '9') {
                return true;
            }
            return c1 == '1' && c2 >= '0' && c2 <= '2';
        }
        return false;
    }

    private static LocalDate date(String num) {
        int y = Integer.parseInt(num.substring(0, 4));
        int m = Integer.parseInt(num.substring(4, 6));
        int d = Integer.parseInt(num.substring(6, 8));
        return LocalDate.of(y, m, d);
    }

    private static LocalTime time(String num, int off) {
        int h = Integer.parseInt(num.substring(off, off + 2));
        int m = Integer.parseInt(num.substring(off + 2, off + 4));
        int s = Integer.parseInt(num.substring(off + 4, off + 6));
        int n = num.length() - off <= 6 ? 0 : Integer.parseInt(num.substring(off + 6)) * 1000000;
        return LocalTime.of(h, m, s, n);
    }

    static enum Ptn {
        DATE(8, new String[]{"2000", "01", "01"}),
        TIME(9, new String[]{"00", "00", "00", "000"}),
        FULL(17, new String[]{"2000", "01", "01", "00", "00", "00", "000"});

        final int len;
        final String[] pad;

        private Ptn(int len, String[] pad) {
            this.len = len;
            this.pad = pad;
        }
    }
}

