/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.time;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class DateLocaling {
    public static LocalDateTime nowDateTime(ZoneId to) {
        return ZonedDateTime.now(to).toLocalDateTime();
    }

    public static LocalDate nowDate(ZoneId to) {
        return ZonedDateTime.now(to).toLocalDate();
    }

    public static LocalTime nowTime(ZoneId to) {
        return ZonedDateTime.now(to).toLocalTime();
    }

    public static LocalDateTime today(ZoneId to) {
        return ZonedDateTime.now(to).toLocalDate().atStartOfDay();
    }

    public static LocalDateTime thisMonth(ZoneId to) {
        return ZonedDateTime.now(to).toLocalDate().withDayOfMonth(1).atStartOfDay();
    }

    public static LocalDateTime pastMonday(ZoneId to) {
        return DateLocaling.pastWeek(to, DayOfWeek.MONDAY);
    }

    public static LocalDateTime pastSunday(ZoneId to) {
        return DateLocaling.pastWeek(to, DayOfWeek.SUNDAY);
    }

    public static LocalDateTime pastWeek(ZoneId to, DayOfWeek day) {
        LocalDateTime ldt = ZonedDateTime.now(to).toLocalDate().atStartOfDay();
        int v = ldt.getDayOfWeek().getValue();
        int m = day.getValue();
        if (m > v) {
            return ldt.plusDays(m - v - 7);
        }
        if (m < v) {
            return ldt.plusDays(m - v);
        }
        return ldt;
    }

    public static LocalDateTime fromZone(LocalDateTime time, ZoneId from) {
        if (time == null) {
            return null;
        }
        if (from == null) {
            return time;
        }
        ZoneId to = ZoneId.systemDefault();
        return DateLocaling.toZone(time, from, to);
    }

    public static LocalDateTime toZone(LocalDateTime time, ZoneId to) {
        if (time == null) {
            return null;
        }
        if (to == null) {
            return time;
        }
        ZoneId from = ZoneId.systemDefault();
        return DateLocaling.toZone(time, from, to);
    }

    public static LocalDateTime toZone(LocalDateTime time, ZoneId from, ZoneId to) {
        if (time == null) {
            return null;
        }
        if (to == null || from == null) {
            return time;
        }
        if (from.equals(to)) {
            return time;
        }
        return time.atZone(from).withZoneSameInstant(to).toLocalDateTime();
    }

    public static LocalDateTime toZone(ZonedDateTime time, ZoneId to) {
        if (time == null) {
            return null;
        }
        if (to == null) {
            return time.toLocalDateTime();
        }
        if (time.getZone().equals(to)) {
            return time.toLocalDateTime();
        }
        return time.withZoneSameInstant(to).toLocalDateTime();
    }

    public static ZonedDateTime zoneZone(ZonedDateTime time, ZoneId to) {
        if (time == null) {
            return null;
        }
        if (to == null) {
            return time;
        }
        if (time.getZone().equals(to)) {
            return time;
        }
        return time.withZoneSameInstant(to);
    }
}

