/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WhiteUtil {
    private static final char[] WS = new char[]{'\t', '\n', '\u000b', '\f', '\r', ' ', '\u0085', '\u00a0', '\u1680', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u202c', '\u202d', '\u202e', '\u2028', '\u2029', '\u202f', '\u205f', '\u3000', '\u180e', '\u200b', '\u200c', '\u200d', '\u2060', '\ufeff'};

    private WhiteUtil() {
    }

    public static boolean notWhiteSpace(char c) {
        for (char w : WS) {
            if (c != w) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhiteSpace(char c) {
        return !WhiteUtil.notWhiteSpace(c);
    }

    @NotNull
    public static String trim(CharSequence str) {
        int i;
        if (str == null) {
            return "";
        }
        int len = str.length();
        int p1 = 0;
        int p2 = len;
        for (i = 0; i < len; ++i) {
            if (!WhiteUtil.notWhiteSpace(str.charAt(i))) continue;
            p1 = i;
            break;
        }
        for (i = len - 1; i >= 0; --i) {
            if (!WhiteUtil.notWhiteSpace(str.charAt(i))) continue;
            p2 = i + 1;
            break;
        }
        if (p1 >= p2) {
            return "";
        }
        if (p1 == 0 && p2 == len) {
            return str.toString();
        }
        return str.subSequence(p1, p2).toString();
    }

    @NotNull
    public static String space(CharSequence str) {
        if (str == null) {
            return "";
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        boolean ws = false;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (WhiteUtil.notWhiteSpace(c)) {
                ws = false;
                sb.append(c);
                continue;
            }
            if (!ws) {
                sb.append(' ');
            }
            ws = true;
        }
        if (sb.length() > 0 && sb.charAt(0) == ' ') {
            sb.deleteCharAt(0);
        }
        if (sb.length() > 1 && sb.charAt(sb.length() - 1) == ' ') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @NotNull
    public static String delete(CharSequence str) {
        if (str == null) {
            return "";
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!WhiteUtil.notWhiteSpace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isAllWhite(CharSequence str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (WhiteUtil.notWhiteSpace(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsWithDeleted(CharSequence str1, CharSequence str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        String s1 = WhiteUtil.delete(str1);
        String s2 = WhiteUtil.delete(str2);
        return s1.equals(s2);
    }

    public static boolean equalsWithSpaced(CharSequence str1, CharSequence str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        String s1 = WhiteUtil.space(str1);
        String s2 = WhiteUtil.space(str2);
        return s1.equals(s2);
    }

    @NotNull
    public static List<String> lines(CharSequence str) {
        int idx;
        String spd = WhiteUtil.space(str);
        int len = spd.length();
        if (len == 0) {
            return Collections.emptyList();
        }
        int cnt = 0;
        for (int i = 0; i < len && (idx = spd.indexOf(32, i)) > 0; ++i) {
            ++cnt;
            i = idx;
        }
        ArrayList<String> result = new ArrayList<String>(cnt + 1);
        for (int i = 0; i < len; ++i) {
            int idx2 = spd.indexOf(32, i);
            if (idx2 <= 0) {
                result.add(spd.substring(i));
                break;
            }
            result.add(spd.substring(i, idx2));
            i = idx2;
        }
        return result;
    }
}

