/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.text;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.text.BuilderHelper;

public class FormatUtil {
    @NotNull
    public static String logback(CharSequence fmt, Object ... args) {
        if (fmt == null || fmt.length() == 0) {
            return "";
        }
        StringBuilder builder = BuilderHelper.getBuilder();
        boolean start = false;
        int i = 0;
        int n = fmt.length();
        block5: for (int j = 0; j < n; ++j) {
            char c = fmt.charAt(j);
            switch (c) {
                case '{': {
                    if (start) {
                        builder.append('{');
                        continue block5;
                    }
                    start = true;
                    continue block5;
                }
                case '}': {
                    if (!start) {
                        builder.append('}');
                        continue block5;
                    }
                    Object arg = null;
                    if (args != null && i < args.length) {
                        arg = args[i++];
                    }
                    start = false;
                    builder.append(arg);
                    continue block5;
                }
                case '\\': {
                    char x;
                    if (start) {
                        start = false;
                        builder.append('{');
                    }
                    if (j + 1 >= n) {
                        builder.append(c);
                        continue block5;
                    }
                    if ((x = fmt.charAt(++j)) == '\\' || x == '{' || x == '}') {
                        builder.append(x);
                        continue block5;
                    }
                    builder.append(c);
                    builder.append(x);
                    continue block5;
                }
                default: {
                    if (start) {
                        start = false;
                        builder.append('{');
                    }
                    builder.append(c);
                }
            }
        }
        if (start) {
            builder.append('{');
        }
        return builder.toString();
    }

    @NotNull
    public static String format(CharSequence fmt, Object ... args) {
        if (fmt == null) {
            return "";
        }
        if (args == null || args.length == 0) {
            return fmt.toString();
        }
        int[] count = FormatUtil.count(fmt, "%", "%%");
        if (count[0] == 0) {
            return fmt.toString();
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            args[i] = "";
        }
        int holds = count[0] - count[1] * 2;
        if (args.length < holds) {
            Object[] g = new Object[holds];
            Arrays.fill(g, "");
            System.arraycopy(args, 0, g, 0, args.length);
            args = g;
        }
        return String.format(fmt.toString(), args);
    }

    @NotNull
    public static String leftFix(@Nullable Object obj, int fix, char pad) {
        String str = obj == null ? "" : obj.toString();
        int len = str.length();
        if (len == fix) {
            return str;
        }
        if (len > fix) {
            return str.substring(len - fix);
        }
        StringBuilder sb = new StringBuilder(fix);
        for (int i = fix - len; i > 0; --i) {
            sb.append(pad);
        }
        sb.append(str);
        return sb.toString();
    }

    @NotNull
    public static String rightFix(@Nullable Object obj, int fix, char pad) {
        String str = obj == null ? "" : obj.toString();
        int len = str.length();
        if (len == fix) {
            return str;
        }
        if (len > fix) {
            return str.substring(0, fix);
        }
        StringBuilder sb = new StringBuilder(fix);
        sb.append(str);
        for (int i = fix - len; i > 0; --i) {
            sb.append(pad);
        }
        return sb.toString();
    }

    public static int count(CharSequence src, String sub) {
        if (src == null || sub == null) {
            return 0;
        }
        return FormatUtil.count(null, src, sub)[0];
    }

    public static int[] count(CharSequence src, String ... sub) {
        return FormatUtil.count(null, src, sub);
    }

    public static int[] count(V viz, CharSequence src, String ... sub) {
        int len;
        if (sub == null) {
            return Null.Ints;
        }
        int[] ct = new int[sub.length];
        int n = len = src == null ? 0 : src.length();
        if (len == 0) {
            return ct;
        }
        int[] ix = new int[sub.length];
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            for (int j = 0; j < sub.length; ++j) {
                String s = sub[j];
                if (s == null || ix[j] < 0) continue;
                char r = s.charAt(ix[j]);
                if (c == r) {
                    ix[j] = ix[j] + 1;
                    int ln = s.length();
                    if (ln != ix[j]) continue;
                    ix[j] = 0;
                    ct[j] = ct[j] + 1;
                    if (viz == null || viz.visit(src, i - ln + 1, s, j)) continue;
                    ix[j] = -1;
                    continue;
                }
                if (ix[j] <= 0) continue;
                ix[j] = 0;
            }
        }
        return ct;
    }

    public static interface V {
        public boolean visit(CharSequence var1, int var2, String var3, int var4);
    }
}

