/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.page;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.page.PageQuery;
import pro.fessional.mirana.page.PageUtil;

public class PageResult<E>
implements Serializable {
    private int pageNumber = 1;
    private int pageSize = 1;
    private int totalPage = 0;
    private int totalData = 0;
    private List<E> data = Collections.emptyList();
    public static final PageResult<?> EMPTY = new PageResult<Object>(){

        @Override
        public PageResult<Object> setPageNumber(int pageNumber) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PageResult<Object> setTotalInfo(int totalData, int pageSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PageResult<Object> setData(Collection<Object> ds) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PageResult<Object> addData(Object d) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PageResult<Object> addData(Collection<Object> ds) {
            throw new UnsupportedOperationException();
        }
    };

    public int getPageNumber() {
        return this.pageNumber;
    }

    public PageResult<E> setPageNumber(int pageNumber) {
        this.pageNumber = Math.max(pageNumber, 1);
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public int getTotalData() {
        return this.totalData;
    }

    public PageResult<E> setTotalInfo(int totalData, int pageSize) {
        this.pageSize = Math.max(pageSize, 1);
        this.totalData = Math.max(totalData, 0);
        this.totalPage = PageUtil.totalPage(totalData, pageSize);
        return this;
    }

    @NotNull
    public List<? extends E> getData() {
        return this.data == null ? Collections.emptyList() : this.data;
    }

    public PageResult<E> setData(Collection<E> ds) {
        if (ds != null && ds.size() > 0) {
            this.data = ds instanceof List ? (List)ds : new ArrayList<E>(ds);
        }
        return this;
    }

    public PageResult<E> addData(E d) {
        if (d != null) {
            if (this.data == null) {
                this.data = new ArrayList(this.pageSize > 0 ? this.pageSize : 20);
            }
            this.data.add(d);
        }
        return this;
    }

    public PageResult<E> addData(Collection<E> ds) {
        if (ds != null && ds.size() > 0) {
            if (this.data == null) {
                this.data = new ArrayList<E>(ds);
            } else {
                this.data.addAll(ds);
            }
        }
        return this;
    }

    public static <T> PageResult<T> of(int totalData, Collection<T> data, PageQuery pg) {
        return new PageResult<T>().setData(data).setPageNumber(pg.getPageNumber()).setTotalInfo(totalData, pg.getPageSize());
    }

    public static <T> PageResult<T> of(int totalData, Collection<T> data, int pageNumber, int pageSize) {
        return new PageResult<T>().setData(data).setPageNumber(pageNumber).setTotalInfo(totalData, pageSize);
    }

    public static <T> PageResult<T> empty() {
        return EMPTY;
    }
}

