/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.data.Null;

public class InputStreams {
    private static final int DEFAULT_BUF_SIZE = 2048;

    @NotNull
    public static byte[] readBytes(InputStream is) {
        if (is == null) {
            return Null.Bytes;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream(is.available());
            InputStreams.readBytes(os, is);
            return os.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to read text", e);
        }
    }

    public static void readBytes(OutputStream os, InputStream is) {
        if (is == null) {
            return;
        }
        try {
            int len;
            byte[] data = new byte[2048];
            while ((len = is.read(data)) != -1) {
                os.write(data, 0, len);
            }
            os.flush();
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to read text", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    public static String readText(InputStream is, Charset cs) {
        if (is == null) {
            return "";
        }
        if (cs == null) {
            cs = StandardCharsets.UTF_8;
        }
        StringBuilder sb = new StringBuilder();
        InputStreams.readText(sb, is, cs);
        return sb.toString();
    }

    public static void readText(StringBuilder sb, InputStream is, Charset cs) {
        if (is == null) {
            return;
        }
        if (cs == null) {
            cs = StandardCharsets.UTF_8;
        }
        char[] buf = new char[2048];
        try (InputStreamReader rd = new InputStreamReader(is, cs);){
            int len;
            while ((len = rd.read(buf)) != -1) {
                sb.append(buf, 0, len);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to read text", e);
        }
    }

    @NotNull
    public static String readText(InputStream is) {
        return InputStreams.readText(is, StandardCharsets.UTF_8);
    }

    @NotNull
    public static List<String> readLine(InputStream is, Charset cs) {
        if (is == null) {
            return Collections.emptyList();
        }
        if (cs == null) {
            cs = StandardCharsets.UTF_8;
        }
        ArrayList<String> rt = new ArrayList<String>();
        InputStreams.readLine(rt, is, cs);
        return rt;
    }

    public static void readLine(List<String> out, InputStream is, Charset cs) {
        if (is == null) {
            return;
        }
        if (cs == null) {
            cs = StandardCharsets.UTF_8;
        }
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(is, cs));){
            String line = rd.readLine();
            while (line != null) {
                out.add(line);
                line = rd.readLine();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to read line", e);
        }
    }

    @NotNull
    public static List<String> readLine(InputStream is) {
        return InputStreams.readLine(is, StandardCharsets.UTF_8);
    }

    public static void saveFile(InputStream is, File file) {
        if (is == null || file == null) {
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            int len;
            byte[] buf = new byte[2048];
            while ((len = is.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to save file " + file, e);
        }
    }

    @NotNull
    public static File saveTemp(InputStream is, String prefix, boolean delOnExit) {
        try {
            File file = Files.createTempFile(prefix, null, new FileAttribute[0]).toFile();
            InputStreams.saveFile(is, file);
            if (delOnExit) {
                file.deleteOnExit();
            }
            return file;
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to save temp", e);
        }
    }

    @NotNull
    public static File saveTemp(InputStream is, String prefix) {
        return InputStreams.saveTemp(is, prefix, false);
    }

    @NotNull
    public static File saveTemp(InputStream is) {
        return InputStreams.saveTemp(is, "mirana-", false);
    }
}

