/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class CircleInputStream
extends InputStream {
    protected InputStream backend;
    protected ByteArrayOutputStream cache = new ByteArrayOutputStream();
    protected ByteArrayInputStream circle = null;
    protected byte[] content = null;
    private boolean finished = false;
    private byte[] markBytes = null;

    public CircleInputStream(InputStream backend) {
        this.backend = backend;
    }

    public boolean isFinished() {
        return this.finished;
    }

    private void switchIfCircle() {
        if (this.content == null) {
            this.content = this.cache.toByteArray();
            this.finished = false;
        }
        if (this.circle == null) {
            this.circle = new ByteArrayInputStream(this.content);
            this.finished = false;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.backend == null) {
            this.switchIfCircle();
            int c = this.circle.read();
            if (c < 0) {
                this.finished = true;
                this.circle = null;
            }
            return c;
        }
        int c = this.backend.read();
        if (c < 0) {
            this.finished = true;
            this.backend = null;
        } else {
            this.cache.write(c);
        }
        return c;
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        if (this.backend == null) {
            this.switchIfCircle();
            int c = this.circle.read(b, off, len);
            if (c < 0) {
                this.finished = true;
                this.circle = null;
            }
            return c;
        }
        int c = this.backend.read(b, off, len);
        if (c < 0) {
            this.finished = true;
            this.backend = null;
        } else {
            this.cache.write(b, 0, c);
        }
        return c;
    }

    @Override
    public long skip(long n) throws IOException {
        int c;
        long r;
        if (this.backend == null) {
            return this.circle == null ? 0L : this.circle.skip(n);
        }
        for (r = n; r > 0L && (c = this.backend.read()) >= 0; --r) {
            this.cache.write(c);
        }
        return n - r;
    }

    @Override
    public int available() throws IOException {
        if (this.backend == null) {
            this.switchIfCircle();
            return this.circle.available();
        }
        return this.backend.available();
    }

    @Override
    public void close() throws IOException {
        if (this.backend != null) {
            this.backend.close();
        }
    }

    @Override
    public void mark(int readlimit) {
        if (this.backend == null) {
            if (this.circle != null) {
                this.circle.mark(readlimit);
            }
        } else {
            this.markBytes = this.cache.toByteArray();
            this.backend.mark(readlimit);
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.backend == null) {
            if (this.circle != null) {
                this.circle.reset();
            }
        } else {
            this.backend.reset();
            this.cache.reset();
            if (this.markBytes != null) {
                this.cache.write(this.markBytes);
                this.markBytes = null;
            }
        }
    }

    @Override
    public boolean markSupported() {
        if (this.backend == null) {
            return this.circle != null;
        }
        return this.backend.markSupported();
    }
}

