/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.img;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import pro.fessional.mirana.img.ImageIoFix;

public class Watermark {
    public static final String WATER_MARK = "/image/watermark-clearance.png";
    public static final int MAX_SIZE = 1024;
    public static final double ROTATE = Math.toRadians(90.0);

    public static BufferedImage exec(String photo) throws IOException {
        return Watermark.exec(photo, false);
    }

    public static BufferedImage exec(String photo, boolean landscape) throws IOException {
        try (FileInputStream fis = new FileInputStream(photo);){
            BufferedImage bufferedImage = Watermark.exec(fis, 1024, landscape);
            return bufferedImage;
        }
    }

    public static BufferedImage exec(String photo, int maxSize, boolean landscape) throws IOException {
        try (FileInputStream fis = new FileInputStream(photo);){
            BufferedImage bufferedImage = Watermark.exec(fis, maxSize, landscape);
            return bufferedImage;
        }
    }

    public static BufferedImage exec(InputStream photo, boolean landscape) throws IOException {
        return Watermark.exec(photo, 1024, landscape);
    }

    public static BufferedImage exec(InputStream photo, int maxSize, boolean landscape) throws IOException {
        InputStream water = Watermark.class.getResourceAsStream(WATER_MARK);
        return Watermark.exec(photo, water, maxSize, landscape);
    }

    public static BufferedImage exec(InputStream photo, InputStream watermark, int maxSize, boolean landscape) throws IOException {
        int space;
        Graphics2D graphics;
        BufferedImage bufferImg;
        BufferedImage photoImg = ImageIoFix.read(photo);
        photo.close();
        int widthPhoto = photoImg.getWidth();
        int heightPhoto = photoImg.getHeight();
        boolean scaled = false;
        if (widthPhoto > maxSize || heightPhoto > maxSize) {
            if (widthPhoto > heightPhoto) {
                heightPhoto = maxSize * heightPhoto / widthPhoto;
                widthPhoto = maxSize;
            } else {
                widthPhoto = maxSize * widthPhoto / heightPhoto;
                heightPhoto = maxSize;
            }
            scaled = true;
        }
        if (landscape && widthPhoto < heightPhoto) {
            bufferImg = new BufferedImage(heightPhoto, widthPhoto, photoImg.getType());
            graphics = bufferImg.createGraphics();
            double offset = (double)(heightPhoto - widthPhoto) / 2.0;
            graphics.translate(offset, -offset);
            graphics.rotate(ROTATE, (double)widthPhoto / 2.0, (double)heightPhoto / 2.0);
        } else {
            bufferImg = new BufferedImage(widthPhoto, heightPhoto, photoImg.getType());
            graphics = bufferImg.createGraphics();
        }
        if (scaled) {
            graphics.drawImage(photoImg.getScaledInstance(widthPhoto, heightPhoto, 4), 0, 0, null);
        } else {
            graphics.drawImage((Image)photoImg, 0, 0, null);
        }
        BufferedImage waterImg = ImageIO.read(watermark);
        watermark.close();
        int widthWater = waterImg.getWidth();
        int heightWater = waterImg.getHeight();
        float alpha = 0.4f;
        graphics.setComposite(AlphaComposite.getInstance(10, alpha));
        for (int waterX = space = 100; waterX < widthPhoto; waterX += widthWater + space) {
            for (int waterY = space; waterY < heightPhoto; waterY += heightWater + space) {
                graphics.drawImage((Image)waterImg, waterX, waterY, null);
            }
        }
        graphics.setComposite(AlphaComposite.getInstance(3));
        graphics.dispose();
        return bufferImg;
    }

    public BufferedImage exec(InputStream photo) throws IOException {
        return Watermark.exec(photo, 1024, false);
    }
}

