/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.img;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class StreamJpg {
    public static final String FORMAT = "JPG";
    public static final float QUALITY = 0.85f;

    public static void writeJpg(OutputStream jpg, BufferedImage image) throws IOException {
        StreamJpg.writeJpg(jpg, image, 0.85f);
    }

    public static void writeJpg(OutputStream jpg, BufferedImage image, float quality) throws IOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        if (iter.hasNext()) {
            ImageWriter writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(quality);
            MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(jpg);
            writer.setOutput(ios);
            writer.write(null, new IIOImage(image, null, null), iwp);
            writer.dispose();
        } else {
            ImageIO.write((RenderedImage)image, FORMAT, jpg);
        }
    }

    public static byte[] bytes(BufferedImage image) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            StreamJpg.writeJpg(baos, image);
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static void file(BufferedImage image, File outjpg) throws IOException {
        File dir = outjpg.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try (FileOutputStream os = new FileOutputStream(outjpg);){
            StreamJpg.writeJpg(os, image);
        }
    }

    public static InputStream tee(BufferedImage image, File outjpg) throws IOException {
        File dir = outjpg.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return StreamJpg.tee(image, new FileOutputStream(outjpg));
    }

    public static InputStream tee(BufferedImage image, OutputStream out) throws IOException {
        byte[] bytes = StreamJpg.bytes(image);
        out.write(bytes);
        out.flush();
        out.close();
        return new ByteArrayInputStream(bytes);
    }
}

