/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.id;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.id.LightIdUtil;

public interface LightIdProvider {
    default public long next(@NotNull String name, int block) {
        return this.next(name, block, 1000L);
    }

    public long next(@NotNull String var1, int var2, long var3);

    public static class Segment {
        private final String name;
        private final int block;
        private final long head;
        private final long foot;

        public Segment(String name, int block, long head, long foot) {
            if (name == null) {
                throw new NullPointerException("name is null");
            }
            if (head > foot) {
                throw new IllegalArgumentException("head=" + head + " is bigger than foot=" + foot);
            }
            if (!LightIdUtil.validBlock(block)) {
                throw new IllegalArgumentException("block=" + block + " is out of range");
            }
            if (!LightIdUtil.validSequence(head)) {
                throw new IllegalArgumentException("head=" + head + " is out of range");
            }
            if (!LightIdUtil.validSequence(foot)) {
                throw new IllegalArgumentException("foot=" + foot + " is out of range");
            }
            this.name = name;
            this.block = block;
            this.head = head;
            this.foot = foot;
        }

        public String getName() {
            return this.name;
        }

        public int getBlock() {
            return this.block;
        }

        public long getHead() {
            return this.head;
        }

        public long getFoot() {
            return this.foot;
        }
    }

    public static interface Loader {
        @NotNull
        public Segment require(@NotNull String var1, int var2, int var3);

        @NotNull
        public List<Segment> preload(int var1);
    }
}

