/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Z {
    @SafeVarargs
    @NotNull
    public static <T> List<T> uniq(Collection<T> ts, Function<? super T, ?> ... fn) {
        if (ts == null) {
            return Collections.emptyList();
        }
        if (fn == null || fn.length == 0) {
            if (ts instanceof List) {
                return (List)ts;
            }
            return new ArrayList<T>(ts);
        }
        HashMap map = new HashMap();
        ArrayList<T> result = new ArrayList<T>(ts.size());
        for (T t : ts) {
            ArrayList ks = new ArrayList(fn.length);
            for (Function<T, ?> function : fn) {
                ks.add(function.apply(t));
            }
            Boolean o = map.putIfAbsent(ks, Boolean.TRUE);
            if (o != null) continue;
            result.add(t);
        }
        return result;
    }

    @SafeVarargs
    @Nullable
    public static <T> T find(Predicate<T> p, T ... ts) {
        if (ts == null) {
            return null;
        }
        for (T t : ts) {
            if (t == null || !p.test(t)) continue;
            return t;
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    public static <T, R> R make(Function<T, R> f, T ... ts) {
        return Z.make(null, f, ts);
    }

    @SafeVarargs
    @Nullable
    public static <T, R> R make(R d, Function<T, R> f, T ... ts) {
        if (ts == null) {
            return null;
        }
        for (T t : ts) {
            if (t == null) continue;
            try {
                R r = f.apply(t);
                if (r == null) continue;
                return r;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    @SafeVarargs
    @Nullable
    public static <T> T notNull(T ... ts) {
        if (ts == null) {
            return null;
        }
        for (T t : ts) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    public static <T extends CharSequence> T notEmpty(T ... ts) {
        if (ts == null) {
            return null;
        }
        for (T t : ts) {
            if (t == null || t.length() <= 0) continue;
            return t;
        }
        return null;
    }

    @Nullable
    public static String notBlank(CharSequence ... ts) {
        if (ts == null) {
            return null;
        }
        for (CharSequence t : ts) {
            String s;
            if (t == null || t.length() <= 0 || (s = t.toString().trim()).length() <= 0) continue;
            return s;
        }
        return null;
    }

    @Nullable
    public static BigDecimal decimal(CharSequence ... ts) {
        return Z.decimal(null, ts);
    }

    @Nullable
    public static BigDecimal decimal(BigDecimal d, CharSequence ... ts) {
        if (ts == null) {
            return null;
        }
        for (CharSequence t : ts) {
            String s;
            if (t == null || t.length() <= 0 || (s = t.toString().trim()).length() <= 0) continue;
            try {
                return new BigDecimal(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    @Nullable
    public static Long int64(CharSequence ... ts) {
        return Z.int64(null, ts);
    }

    @Nullable
    public static Long int64(Long d, CharSequence ... ts) {
        if (ts == null) {
            return null;
        }
        for (CharSequence t : ts) {
            String s;
            if (t == null || t.length() <= 0 || (s = t.toString().trim()).length() <= 0) continue;
            try {
                return Long.valueOf(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    @Nullable
    public static Integer int32(CharSequence ... ts) {
        return Z.int32(null, ts);
    }

    @Nullable
    public static Integer int32(Integer d, CharSequence ... ts) {
        if (ts == null) {
            return null;
        }
        for (CharSequence t : ts) {
            String s;
            if (t == null || t.length() <= 0 || (s = t.toString().trim()).length() <= 0) continue;
            try {
                return Integer.valueOf(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }
}

