/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.data;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.data.CodeEnum;
import pro.fessional.mirana.data.DataResult;
import pro.fessional.mirana.i18n.I18nAware;
import pro.fessional.mirana.pain.ThrowableUtil;

public class R<T>
implements DataResult<T> {
    protected boolean success;
    protected String message;
    protected String code;
    protected T data;
    protected String error = null;

    protected R(boolean success, String message, String code, T data) {
        this.success = success;
        this.message = message;
        this.code = code;
        this.data = data;
    }

    protected R(boolean success, CodeEnum code, T data) {
        this.success = success;
        this.data = data;
        if (code != null) {
            this.message = code.getHint();
            this.code = code.getCode();
        }
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    public R<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.message;
    }

    public R<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    @Override
    @Nullable
    public T getData() {
        return this.data;
    }

    public R<T> setData(T data) {
        this.data = data;
        return this;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public R<T> setCode(String code) {
        this.code = code;
        return this;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getError() {
        return this.error;
    }

    public I<T> toI18n(String code, Object ... args) {
        I<T> r = new I<T>(this.success, this.message, this.code, this.data);
        if (code != null && code.length() > 0) {
            ((I)r).i18nCode = code;
        }
        if (args != null && args.length > 0) {
            I.access$102(r, args);
        }
        return r;
    }

    public String toString() {
        return "SimpleResult{success=" + this.success + ", message='" + this.message + '\'' + ", code='" + this.code + '\'' + ", data=" + this.data + '}';
    }

    public static <T> R<T> of(boolean success) {
        return new R<Object>(success, null, null, null);
    }

    public static <T> R<T> of(boolean success, String message) {
        return new R<Object>(success, message, null, null);
    }

    public static <T> R<T> of(boolean success, CodeEnum code) {
        return new R<Object>(success, code, null);
    }

    public static <T> R<T> of(boolean success, String message, String code) {
        return new R<Object>(success, message, code, null);
    }

    public static <T> R<T> of(boolean success, String message, String code, T data) {
        return new R<T>(success, message, code, data);
    }

    public static <T> R<T> of(boolean success, CodeEnum code, T data) {
        return new R<T>(success, code, data);
    }

    public static <T> R<T> of(boolean success, CodeEnum code, String message, T data) {
        return new R<T>(success, code, data).setMessage(message);
    }

    public static <T> R<T> ok() {
        return new R<Object>(true, null, null, null);
    }

    public static <T> R<T> ok(String message) {
        return new R<Object>(true, message, null, null);
    }

    public static <T> R<T> ok(CodeEnum code) {
        return new R<Object>(true, code, null);
    }

    public static <T> R<T> ok(String message, T data) {
        return new R<T>(true, message, null, data);
    }

    public static <T> R<T> ok(String message, String code, T data) {
        return new R<T>(true, message, code, data);
    }

    public static <T> R<T> ok(CodeEnum code, T data) {
        return new R<T>(true, code, data);
    }

    public static <T> R<T> okCode(String code) {
        return new R<Object>(true, null, code, null);
    }

    public static <T> R<T> okCode(String code, String message) {
        return new R<Object>(true, message, code, null);
    }

    public static <T> R<T> okCode(CodeEnum code, String message) {
        return new R<Object>(true, code, null).setMessage(message);
    }

    public static <T> R<T> okData(T data) {
        return new R<T>(true, null, null, data);
    }

    public static <T> R<T> okData(T data, String code) {
        return new R<T>(true, null, code, data);
    }

    public static <T> R<T> ng() {
        return new R<Object>(false, null, null, null);
    }

    public static <T> R<T> ng(String message) {
        return new R<Object>(false, message, null, null);
    }

    public static <T> R<T> ng(CodeEnum code) {
        return new R<Object>(false, code, null);
    }

    public static <T> R<T> ng(String message, String code) {
        return new R<Object>(false, message, code, null);
    }

    public static <T> R<T> ng(String message, String code, T data) {
        return new R<T>(false, message, code, data);
    }

    public static <T> R<T> ng(CodeEnum code, T data) {
        return new R<T>(false, code, data);
    }

    public static <T> R<T> ngCode(String code) {
        return new R<Object>(false, null, code, null);
    }

    public static <T> R<T> ngCode(String code, String message) {
        return new R<Object>(false, message, code, null);
    }

    public static <T> R<T> ngCode(CodeEnum code, String message) {
        return new R<Object>(false, code, null).setMessage(message);
    }

    public static <T> R<T> ngData(T data) {
        return new R<T>(false, null, null, data);
    }

    public static <T> R<T> ngData(T data, String code) {
        return new R<T>(false, null, code, data);
    }

    public static <T> R<T> ng(Throwable t) {
        return R.ng(t, null, null);
    }

    public static <T> R<T> ng(Throwable t, String code) {
        return R.ng(t, code, null);
    }

    public static <T> R<T> ng(Throwable t, String code, String message) {
        if (message == null) {
            message = t.getMessage();
        }
        String st = ThrowableUtil.rootString(t);
        String b64 = Base64.getUrlEncoder().encodeToString(st.getBytes(StandardCharsets.UTF_8));
        if (code == null && t instanceof DataResult) {
            code = ((DataResult)((Object)t)).getCode();
        }
        R<Object> tr = new R<Object>(false, message, code, null);
        tr.error = b64;
        return tr;
    }

    public static <T> R<T> ng(Throwable t, CodeEnum code) {
        String st = ThrowableUtil.rootString(t);
        String b64 = Base64.getUrlEncoder().encodeToString(st.getBytes(StandardCharsets.UTF_8));
        R<Object> tr = new R<Object>(false, code, null);
        tr.error = b64;
        return tr;
    }

    public static class I<T>
    extends R<T>
    implements I18nAware {
        private String i18nCode;
        private Object[] i18nArgs;

        protected I(boolean success, String message, String code, T data) {
            super(success, message, code, data);
        }

        @Override
        public String getI18nCode() {
            return this.i18nCode;
        }

        @Override
        public Object[] getI18nArgs() {
            return this.i18nArgs;
        }

        static /* synthetic */ Object[] access$102(I x0, Object[] x1) {
            x0.i18nArgs = x1;
            return x1;
        }
    }
}

