/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.code;

public class Crc4Int {
    private static final int MAX_BIT = 31;
    private static final int CRC_BIT = 4;
    private static final int MID_BIT = 14;
    private static final int MSK_MID = 16383;
    private static final int MSK_CRC = 15;
    public static final int MAX_SEQ = 0x8000000;
    public static final int MIN_SEQ = 0;
    public static final int MAX_LEN = 10;
    public static final int MIN_LEN = 7;

    public static int decode(int seq) {
        int temp = seq >>> 14;
        int body = temp & 0xF;
        int head = temp >>> 4;
        int foot = seq & 0x3FFF;
        int result = head << 14 | foot;
        return body == Crc4Int.crc4(result) ? result : -1;
    }

    public static int encode(int seq) {
        int crc = Crc4Int.crc4(seq);
        int foot = seq & 0x3FFF;
        int head = seq >>> 14;
        int temp = head << 4 | crc;
        return temp << 14 | foot;
    }

    private static int crc4(int b) {
        int gply = 19;
        int mask = 15;
        int offb = 27;
        int i = 0;
        while (b > 15) {
            if ((b >>> 31 - i & 1) == 1) {
                b ^= 19 << 27 - i;
            }
            ++i;
        }
        return b;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 0x8000000; ++i) {
            int num = Crc4Int.encode(i);
            int seq = Crc4Int.decode(num);
            if (i != seq) {
                System.err.println(i + ":" + seq + ":" + num);
                return;
            }
            if (i >= 10000) continue;
            System.out.printf("%04d\t%06d\n", i, num);
        }
    }
}

