/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.bits;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.bits.Bytes;
import pro.fessional.mirana.io.InputStreams;

public class Md5 {
    @NotNull
    public static String sum(@Nullable String str) {
        if (str == null) {
            return "";
        }
        return Md5.sum(str.getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public static String sum(@Nullable InputStream ins) {
        if (ins == null) {
            return "";
        }
        byte[] bytes = InputStreams.readBytes(ins);
        return Md5.sum(bytes);
    }

    @NotNull
    public static String sum(@Nullable byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(bytes);
            byte[] hash = digest.digest();
            return Bytes.hex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("can not init MD5,", e);
        }
    }

    public static boolean check(@Nullable String sum, @Nullable byte[] bytes) {
        if (bytes == null || sum == null) {
            return false;
        }
        String md5 = Md5.sum(bytes);
        return sum.equalsIgnoreCase(md5);
    }

    public static boolean check(@Nullable String sum, @Nullable String str) {
        if (str == null || sum == null) {
            return false;
        }
        String md5 = Md5.sum(str);
        return sum.equalsIgnoreCase(md5);
    }

    public static boolean check(@Nullable String sum, @Nullable InputStream ins) {
        if (ins == null || sum == null) {
            return false;
        }
        String md5 = Md5.sum(ins);
        return sum.equalsIgnoreCase(md5);
    }
}

