/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.bits;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.io.InputStreams;

public class Base64 {
    public static Base64.Encoder getEncoder(boolean urlSafe) {
        return urlSafe ? java.util.Base64.getUrlEncoder() : java.util.Base64.getEncoder();
    }

    @NotNull
    public static String encode(@Nullable String str) {
        return Base64.encode(str, true);
    }

    @NotNull
    public static String encode(@Nullable InputStream ins) {
        return Base64.encode(ins, true);
    }

    @NotNull
    public static String encode(@Nullable byte[] bytes) {
        return Base64.encode(bytes, true);
    }

    @NotNull
    public static String encode(@Nullable String str, boolean urlSafe) {
        if (str == null) {
            return "";
        }
        return Base64.getEncoder(urlSafe).encodeToString(str.getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public static String encode(@Nullable InputStream ins, boolean urlSafe) {
        if (ins == null) {
            return "";
        }
        byte[] bytes = InputStreams.readBytes(ins);
        return Base64.getEncoder(urlSafe).encodeToString(bytes);
    }

    @NotNull
    public static String encode(@Nullable byte[] bytes, boolean urlSafe) {
        if (bytes == null) {
            return "";
        }
        return Base64.getEncoder(urlSafe).encodeToString(bytes);
    }

    @NotNull
    public static String de2str(@Nullable String str) {
        if (str == null) {
            return "";
        }
        byte[] bytes = Base64.decode(str.getBytes(StandardCharsets.UTF_8));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @NotNull
    public static String de2str(@Nullable byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        byte[] res = Base64.decode(bytes);
        return new String(res, StandardCharsets.UTF_8);
    }

    @NotNull
    public static String de2str(@Nullable InputStream ins) {
        if (ins == null) {
            return "";
        }
        byte[] bytes = InputStreams.readBytes(ins);
        byte[] res = Base64.decode(bytes);
        return new String(res, StandardCharsets.UTF_8);
    }

    @NotNull
    public static byte[] decode(@Nullable String str) {
        if (str == null) {
            return Null.Bytes;
        }
        return Base64.decode(str.getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public static byte[] decode(@Nullable byte[] bytes) {
        if (bytes == null) {
            return Null.Bytes;
        }
        boolean urlSafe = true;
        for (byte c : bytes) {
            if (c != 43 && c != 47) continue;
            urlSafe = false;
            break;
        }
        Base64.Decoder decoder = urlSafe ? java.util.Base64.getUrlDecoder() : java.util.Base64.getDecoder();
        return decoder.decode(bytes);
    }

    @NotNull
    public static byte[] decode(@Nullable InputStream ins) {
        if (ins == null) {
            return Null.Bytes;
        }
        byte[] bytes = InputStreams.readBytes(ins);
        return Base64.decode(bytes);
    }
}

