/*
 * Decompiled with CFR 0.152.
 */
package pro.felixo.protobuf.protoscope;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.felixo.protobuf.protoscope.ProtoscopeTokenizer;
import pro.felixo.protobuf.protoscope.Token;
import pro.felixo.protobuf.util.PeekableIterator;
import pro.felixo.protobuf.wire.Tag;
import pro.felixo.protobuf.wire.UtilKt;
import pro.felixo.protobuf.wire.WireBuffer;
import pro.felixo.protobuf.wire.WireType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0012\u0010\u0015\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u000f0\u0016H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lpro/felixo/protobuf/protoscope/ProtoscopeConverter;", "", "tokenizer", "Lpro/felixo/protobuf/protoscope/ProtoscopeTokenizer;", "(Lpro/felixo/protobuf/protoscope/ProtoscopeTokenizer;)V", "currentLongForm", "Lpro/felixo/protobuf/protoscope/Token$LongForm;", "convert", "", "protoscope", "", "convertBlock", "Lpro/felixo/protobuf/wire/WireBuffer;", "tokens", "Lpro/felixo/protobuf/util/PeekableIterator;", "Lpro/felixo/protobuf/protoscope/Token;", "expectCloseBrace", "", "inferType", "", "popExtraBytes", "expectToken", "", "protobuf-kotlin-protoscope"})
@SourceDebugExtension(value={"SMAP\nProtoscopeConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtoscopeConverter.kt\npro/felixo/protobuf/protoscope/ProtoscopeConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class ProtoscopeConverter {
    @NotNull
    private final ProtoscopeTokenizer tokenizer;
    @Nullable
    private Token.LongForm currentLongForm;

    public ProtoscopeConverter(@NotNull ProtoscopeTokenizer tokenizer) {
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this.tokenizer = tokenizer;
    }

    public /* synthetic */ ProtoscopeConverter(ProtoscopeTokenizer protoscopeTokenizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            protoscopeTokenizer = new ProtoscopeTokenizer();
        }
        this(protoscopeTokenizer);
    }

    @NotNull
    public final byte[] convert(@NotNull String protoscope) {
        Intrinsics.checkNotNullParameter((Object)protoscope, (String)"protoscope");
        this.currentLongForm = null;
        WireBuffer result = this.convertBlock(new PeekableIterator<Token>(this.tokenizer.tokenize(protoscope).iterator()), false);
        if (!(this.currentLongForm == null)) {
            boolean bl = false;
            String string = "Unmatched long-form token encountered at end of input.";
            throw new IllegalStateException(string.toString());
        }
        return result.getBytes();
    }

    /*
     * WARNING - void declaration
     */
    private final WireBuffer convertBlock(PeekableIterator<Token> tokens, boolean expectCloseBrace) {
        WireBuffer out = new WireBuffer(null, 0, 0, 7, null);
        while (tokens.hasNext()) {
            int $i$a$-check-ProtoscopeConverter$convertBlock$162;
            Token token = this.expectToken((Iterator<? extends Token>)tokens);
            if (token instanceof Token.BooleanLiteral) {
                out.writeVarInt(((Token.BooleanLiteral)token).getValue() ? 1 : 0, this.popExtraBytes());
                continue;
            }
            if (token instanceof Token.BytesLiteral) {
                if (!(this.currentLongForm == null)) {
                    boolean $i$a$-check-ProtoscopeConverter$convertBlock$82 = false;
                    String $i$a$-check-ProtoscopeConverter$convertBlock$82 = "Long-form cannot be applied to bytes literals - missing an open brace?";
                    throw new IllegalStateException($i$a$-check-ProtoscopeConverter$convertBlock$82.toString());
                }
                out.write(((Token.BytesLiteral)token).getBytes());
                continue;
            }
            if (Intrinsics.areEqual((Object)token, (Object)Token.CloseBrace.INSTANCE)) {
                if (!expectCloseBrace) {
                    boolean $i$a$-check-ProtoscopeConverter$convertBlock$112 = false;
                    String $i$a$-check-ProtoscopeConverter$convertBlock$112 = "Unexpected closing brace.";
                    throw new IllegalStateException($i$a$-check-ProtoscopeConverter$convertBlock$112.toString());
                }
                return out;
            }
            if (Intrinsics.areEqual((Object)token, (Object)Token.OpenBrace.INSTANCE)) {
                int extraBytes = this.popExtraBytes();
                WireBuffer bytes = this.convertBlock(tokens, true);
                if (!(this.currentLongForm == null)) {
                    boolean $i$a$-check-ProtoscopeConverter$convertBlock$122 = false;
                    String $i$a$-check-ProtoscopeConverter$convertBlock$122 = "Long-form cannot be applied to the end of LEN groups.";
                    throw new IllegalStateException($i$a$-check-ProtoscopeConverter$convertBlock$122.toString());
                }
                out.writeVarInt(bytes.getLength(), extraBytes);
                out.writeAndConsume(bytes);
                continue;
            }
            if (Intrinsics.areEqual((Object)token, (Object)Token.OpenGroupBrace.INSTANCE)) {
                throw new IllegalStateException("Unexpected open group brace that does not follow a tag expression.".toString());
            }
            if (token instanceof Token.StringLiteral) {
                if (!(this.currentLongForm == null)) {
                    boolean $i$a$-check-ProtoscopeConverter$convertBlock$132 = false;
                    String $i$a$-check-ProtoscopeConverter$convertBlock$132 = "Long-form cannot be applied to string literals - missing an open brace?";
                    throw new IllegalStateException($i$a$-check-ProtoscopeConverter$convertBlock$132.toString());
                }
                out.write(StringsKt.encodeToByteArray((String)((Token.StringLiteral)token).getText()));
                continue;
            }
            if (token instanceof Token.FloatLiteral) {
                if (!(this.currentLongForm == null)) {
                    boolean $i$a$-check-ProtoscopeConverter$convertBlock$142 = false;
                    String $i$a$-check-ProtoscopeConverter$convertBlock$142 = "Long-form cannot be applied to floating-point numbers.";
                    throw new IllegalStateException($i$a$-check-ProtoscopeConverter$convertBlock$142.toString());
                }
                if (((Token.FloatLiteral)token).isDouble()) {
                    out.writeFixed64(Double.doubleToRawLongBits(((Token.FloatLiteral)token).getValue()));
                    continue;
                }
                int value = Float.floatToRawIntBits((float)((Token.FloatLiteral)token).getValue());
                out.writeFixed32(value);
                continue;
            }
            if (token instanceof Token.IntegerLiteral) {
                switch (WhenMappings.$EnumSwitchMapping$0[((Token.IntegerLiteral)token).getType().ordinal()]) {
                    case 1: {
                        if (!(this.currentLongForm == null)) {
                            boolean $i$a$-check-ProtoscopeConverter$convertBlock$152 = false;
                            String $i$a$-check-ProtoscopeConverter$convertBlock$152 = "Long-form cannot be applied to fixed32.";
                            throw new IllegalStateException($i$a$-check-ProtoscopeConverter$convertBlock$152.toString());
                        }
                        out.writeFixed32((int)((Token.IntegerLiteral)token).getValue());
                        break;
                    }
                    case 2: {
                        if (!(this.currentLongForm == null)) {
                            $i$a$-check-ProtoscopeConverter$convertBlock$162 = 0;
                            String $i$a$-check-ProtoscopeConverter$convertBlock$162 = "Long-form cannot be applied to fixed64.";
                            throw new IllegalStateException($i$a$-check-ProtoscopeConverter$convertBlock$162.toString());
                        }
                        out.writeFixed64(((Token.IntegerLiteral)token).getValue());
                        break;
                    }
                    case 3: {
                        out.writeVarInt(((Token.IntegerLiteral)token).getValue(), this.popExtraBytes());
                        break;
                    }
                    case 4: {
                        out.writeVarInt(UtilKt.encodeSInt64((long)((Token.IntegerLiteral)token).getValue()), this.popExtraBytes());
                    }
                }
                continue;
            }
            if (token instanceof Token.Tag) {
                int n;
                Integer inferredType = null;
                WireBuffer wireBuffer = out;
                Tag.Companion companion = Tag.Companion;
                int n2 = ((Token.Tag)token).getNumber();
                Integer n3 = ((Token.Tag)token).getType();
                if (n3 != null) {
                    n = n3;
                } else {
                    void it;
                    int n4;
                    $i$a$-check-ProtoscopeConverter$convertBlock$162 = n4 = this.inferType(tokens);
                    int n5 = n2;
                    Tag.Companion companion2 = companion;
                    WireBuffer wireBuffer2 = wireBuffer;
                    boolean bl = false;
                    inferredType = (int)it;
                    Unit unit = Unit.INSTANCE;
                    wireBuffer = wireBuffer2;
                    companion = companion2;
                    n2 = n5;
                    n = n4;
                }
                wireBuffer.writeVarInt(companion.of-c1Vkjso(n2, n), this.popExtraBytes());
                Integer n6 = inferredType;
                int $i$a$-check-ProtoscopeConverter$convertBlock$142 = WireType.SGroup.getValue();
                if (n6 == null || n6 != $i$a$-check-ProtoscopeConverter$convertBlock$142) continue;
                if (!(this.expectToken((Iterator<? extends Token>)tokens) instanceof Token.OpenGroupBrace)) {
                    boolean bl = false;
                    String string = "Expected open group brace after inferred SGroup tag.";
                    throw new IllegalStateException(string.toString());
                }
                out.writeAndConsume(this.convertBlock(tokens, true));
                out.writeVarInt(Tag.Companion.of-c1Vkjso(((Token.Tag)token).getNumber(), WireType.EGroup.getValue()), this.popExtraBytes());
                continue;
            }
            if (!(token instanceof Token.LongForm)) continue;
            if (!(this.currentLongForm == null)) {
                boolean bl = false;
                String string = "Two consecutive long-form tags are not permitted.";
                throw new IllegalStateException(string.toString());
            }
            this.currentLongForm = (Token.LongForm)token;
        }
        if (expectCloseBrace) {
            throw new IllegalStateException("Unexpected end of input; missing closing brace.".toString());
        }
        return out;
    }

    private final int popExtraBytes() {
        int n;
        Token.LongForm longForm = this.currentLongForm;
        int it = n = longForm != null ? longForm.getExtraBytes() : 0;
        boolean bl = false;
        this.currentLongForm = null;
        return n;
    }

    private final int inferType(PeekableIterator<Token> tokens) {
        int n;
        block18: {
            Token token;
            block20: {
                block19: {
                    block17: {
                        token = tokens.peek();
                        if (!(token instanceof Token.BooleanLiteral)) break block17;
                        n = WireType.VarInt.getValue();
                        break block18;
                    }
                    if (token instanceof Token.BytesLiteral) {
                        throw new IllegalStateException("Unexpected token: bytes after typeless tag - missing an open brace?".toString());
                    }
                    if (Intrinsics.areEqual((Object)token, (Object)Token.CloseBrace.INSTANCE)) {
                        throw new IllegalStateException("Unexpected token: close brace after typeless tag - missing an open brace?".toString());
                    }
                    if (!(token instanceof Token.FloatLiteral)) break block19;
                    n = ((Token.FloatLiteral)token).isDouble() ? WireType.Fixed64.getValue() : WireType.Fixed32.getValue();
                    break block18;
                }
                if (!(token instanceof Token.IntegerLiteral)) break block20;
                switch (WhenMappings.$EnumSwitchMapping$0[((Token.IntegerLiteral)token).getType().ordinal()]) {
                    case 1: {
                        n = WireType.Fixed32.getValue();
                        break block18;
                    }
                    case 2: {
                        n = WireType.Fixed64.getValue();
                        break block18;
                    }
                    case 3: {
                        n = WireType.VarInt.getValue();
                        break block18;
                    }
                    case 4: {
                        n = WireType.VarInt.getValue();
                        break block18;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (Intrinsics.areEqual((Object)token, (Object)Token.OpenBrace.INSTANCE)) {
                n = WireType.Len.getValue();
            } else if (Intrinsics.areEqual((Object)token, (Object)Token.OpenGroupBrace.INSTANCE)) {
                n = WireType.SGroup.getValue();
            } else {
                if (token instanceof Token.StringLiteral) {
                    throw new IllegalStateException("Unexpected token: string after typeless tag - missing an open brace?".toString());
                }
                if (token instanceof Token.Tag) {
                    throw new IllegalStateException("Unexpected token: tag after typeless tag - missing an open brace?".toString());
                }
                if (token instanceof Token.LongForm) {
                    n = this.inferType(tokens);
                } else {
                    if (token == null) {
                        throw new IllegalStateException("Unexpected end of input after typeless tag".toString());
                    }
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return n;
    }

    private final Token expectToken(Iterator<? extends Token> $this$expectToken) {
        if (!$this$expectToken.hasNext()) {
            throw new IllegalStateException("Unexpected end of input".toString());
        }
        return $this$expectToken.next();
    }

    public ProtoscopeConverter() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Token.IntegerLiteral.Type.values().length];
            try {
                nArray[Token.IntegerLiteral.Type.Fixed32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.IntegerLiteral.Type.Fixed64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.IntegerLiteral.Type.VarInt.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.IntegerLiteral.Type.SVarInt.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

