/*
 * Decompiled with CFR 0.152.
 */
package pro.cutout.api;

import com.alibaba.fastjson.JSON;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import pro.cutout.api.CutoutClient;
import pro.cutout.api.requests.CartoonSelfieToBase64ByFileRequest;
import pro.cutout.api.requests.CartoonSelfieToBase64ByUrlRequest;
import pro.cutout.api.requests.CartoonSelfieToByteByFileRequest;
import pro.cutout.api.requests.FaceCutoutToBase64ByFileRequest;
import pro.cutout.api.requests.FaceCutoutToBase64ByUrlRequest;
import pro.cutout.api.requests.FaceCutoutToByteByFileRequest;
import pro.cutout.api.requests.ImageRetouchRequest;
import pro.cutout.api.requests.PassportPhotoRequest;
import pro.cutout.api.requests.PhotoAnimerTaskCreateRequest;
import pro.cutout.api.requests.PhotoAnimerTaskGetRequest;
import pro.cutout.api.requests.PhotoColorizerToBase64ByFileRequest;
import pro.cutout.api.requests.PhotoColorizerToBase64ByUrlRequest;
import pro.cutout.api.requests.PhotoColorizerToByteByFileRequest;
import pro.cutout.api.requests.PhotoEnhancerToBase64ByFileRequest;
import pro.cutout.api.requests.PhotoEnhancerToBase64ByUrlRequest;
import pro.cutout.api.requests.PhotoEnhancerToByteByFileRequest;
import pro.cutout.api.requests.RemoveBackgroundToBase64ByFileRequest;
import pro.cutout.api.requests.RemoveBackgroundToBase64ByUrlRequest;
import pro.cutout.api.requests.RemoveBackgroundToByteByFileRequest;
import pro.cutout.api.responses.CartoonSelfieToBase64ByFileResponse;
import pro.cutout.api.responses.CartoonSelfieToByteByFileResponse;
import pro.cutout.api.responses.FaceCutoutToBase64ByFileResponse;
import pro.cutout.api.responses.FaceCutoutToBase64ByUrlResponse;
import pro.cutout.api.responses.FaceCutoutToByteByFileResponse;
import pro.cutout.api.responses.ImageRetouchResponse;
import pro.cutout.api.responses.PassportPhotoResponse;
import pro.cutout.api.responses.PhotoAnimerTaskCreateResponse;
import pro.cutout.api.responses.PhotoAnimerTaskGetResponse;
import pro.cutout.api.responses.PhotoColorizerToBase64ByFileResponse;
import pro.cutout.api.responses.PhotoColorizerToBase64ByUrlResponse;
import pro.cutout.api.responses.PhotoColorizerToByteByFileResponse;
import pro.cutout.api.responses.PhotoEnhancerToBase64ByFileResponse;
import pro.cutout.api.responses.PhotoEnhancerToBase64ByUrlResponse;
import pro.cutout.api.responses.PhotoEnhancerToByteByFileResponse;
import pro.cutout.api.responses.RemoveBackgroundToBase64ByFileResponse;
import pro.cutout.api.responses.RemoveBackgroundToBase64ByUrlResponse;
import pro.cutout.api.responses.RemoveBackgroundToByteByFileResponse;

class UnitTests {
    static String defaultServerUrl = "http://restapi.picup.shop/api/v1";
    static String defaultApiKey = "c66864a7eabc45b18aaf9483aeb82dc9";
    static String manUrl = "https://deeplor.oss-cn-hangzhou.aliyuncs.com/site/picup/cn-home/face1.jpg";
    static String grayScaleUrl = "https://deeplor.oss-cn-hangzhou.aliyuncs.com/site/picup/cn-home/photoColoring3.jpg";
    static CutoutClient client;
    static Map<String, byte[]> cache;

    UnitTests() {
    }

    public static ByteArrayInputStream getResources(String name) {
        byte[] bytes = cache.computeIfAbsent(name, key -> {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);){
                int i;
                byte[] buffer = new byte[1024];
                while ((i = inputStream.read(buffer)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, i);
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                return byArray;
            }
            catch (Exception e) {
                return null;
            }
        });
        return new ByteArrayInputStream(bytes);
    }

    private static void cutoutClientInstance(String[] args) {
        long length = args.length;
        String serverUrl = length > 0L ? args[0] : defaultServerUrl;
        String apiKey = length > 1L ? args[1] : defaultApiKey;
        System.out.println("api url:" + serverUrl + "; api key:" + apiKey);
        client = new CutoutClient(serverUrl, apiKey);
    }

    public static void main(String[] args) throws Exception {
        int i;
        UnitTests.cutoutClientInstance(args);
        long t1 = System.currentTimeMillis();
        boolean success = UnitTests.imageRetouch();
        System.out.println("\u56fe\u7247\u4fee\u590d[\u6267\u884c\u72b6\u6001:" + success + "]");
        success = UnitTests.passportPhoto();
        System.out.println("\u8bc1\u4ef6\u7167[\u6267\u884c\u72b6\u6001:" + success + "]");
        success = UnitTests.removeBackgroundToByteByFile();
        System.out.println("\u901a\u7528\u62a0\u56fe[file->byte;\u6267\u884c\u72b6\u6001:" + success + "]");
        success = UnitTests.removeBackgroundToBase64ByFile();
        System.out.println("\u901a\u7528\u62a0\u56fe[file->base64;\u6267\u884c\u72b6\u6001:" + success + "]");
        success = UnitTests.removeBackgroundToBase64ByUrl();
        System.out.println("\u901a\u7528\u62a0\u56fe[url->base64;\u6267\u884c\u72b6\u6001:" + success + "]");
        success = UnitTests.photoEnhancerToByteByFile();
        System.out.println("\u56fe\u7247\u9ad8\u6e05[file->byte;\u6267\u884c\u72b6\u6001:" + success + "]");
        success = UnitTests.photoEnhancerToBase64ByFile();
        System.out.println("\u56fe\u7247\u9ad8\u6e05[file->base64;\u6267\u884c\u72b6\u6001:" + success + "]");
        success = UnitTests.photoEnhancerToBase64ByUrl();
        System.out.println("\u56fe\u7247\u9ad8\u6e05[url->base64;\u6267\u884c\u72b6\u6001:" + success + "]");
        success = UnitTests.faceCutoutToByteByFile();
        System.out.println("\u5934\u50cf\u62a0\u56fe[file->byte;\u6267\u884c\u72b6\u6001:" + success + "]");
        success = UnitTests.faceCutoutToBase64ByFile();
        System.out.println("\u5934\u50cf\u62a0\u56fe[file->base64;\u6267\u884c\u72b6\u6001:" + success + "]");
        success = UnitTests.faceCutoutToBase64ByUrl();
        System.out.println("\u5934\u50cf\u62a0\u56fe[url->base64;\u6267\u884c\u72b6\u6001:" + success + "]");
        success = UnitTests.photoColorizerToByteByFile();
        System.out.println("\u56fe\u7247\u4e0a\u8272[file->byte;\u6267\u884c\u72b6\u6001:" + success + "]");
        success = UnitTests.photoColorizerToBase64ByFile();
        System.out.println("\u56fe\u7247\u4e0a\u8272[file->base64;\u6267\u884c\u72b6\u6001:" + success + "]");
        success = UnitTests.photoColorizerToBase64ByUrl();
        System.out.println("\u56fe\u7247\u4e0a\u8272[url->base64;\u6267\u884c\u72b6\u6001:" + success + "]");
        success = UnitTests.cartoonSelfieToBase64ByFile();
        System.out.println("\u5361\u901a\u5934\u50cf[file->base64;\u6267\u884c\u72b6\u6001:" + success + "]");
        success = UnitTests.cartoonSelfieToBase64ByUrl();
        System.out.println("\u5361\u901a\u5934\u50cf[url->base64;\u6267\u884c\u72b6\u6001:" + success + "]");
        for (i = 0; i <= 8; ++i) {
            success = UnitTests.cartoonSelfieToByteByFile(i);
            System.out.println("\u5361\u901a\u5934\u50cf[file->byte; cartoonType:" + i + "; \u6267\u884c\u72b6\u6001:" + success + "]");
        }
        for (i = 0; i <= 13; ++i) {
            success = UnitTests.photoAnimerTaskGet(i);
            System.out.println("\u7167\u7247\u53d8\u6d3b[templateId:" + i + ";\u6267\u884c\u72b6\u6001:" + success + "]");
        }
        long t2 = System.currentTimeMillis();
        System.out.println("\u6d4b\u8bd5\u5b8c\u6bd5\uff0c\u8017\u65f6\uff1a" + (t2 - t1));
    }

    public static boolean photoAnimerTaskGet(Integer templateId) throws Exception {
        Long taskId = UnitTests.photoAnimerTaskCreate(templateId);
        if (taskId == null) {
            return Boolean.FALSE;
        }
        for (int i = 0; i <= 100; ++i) {
            PhotoAnimerTaskGetRequest request = new PhotoAnimerTaskGetRequest();
            request.setTaskId(taskId);
            PhotoAnimerTaskGetResponse response = client.execute(request);
            PhotoAnimerTaskGetResponse.Data date = (PhotoAnimerTaskGetResponse.Data)response.getData();
            if (date.getStatus().equals(1)) {
                return Boolean.TRUE;
            }
            if (date.getStatus().equals(2)) {
                System.out.println(JSON.toJSONString(response));
                return Boolean.FALSE;
            }
            Thread.sleep(1000L);
        }
        return Boolean.FALSE;
    }

    public static Long photoAnimerTaskCreate(Integer templateId) throws Exception {
        PhotoAnimerTaskCreateRequest request = new PhotoAnimerTaskCreateRequest();
        request.setImageUrl("https://deeplor.oss-cn-hangzhou.aliyuncs.com/site/picup/cn-home/face1.jpg");
        request.setTemplateId(templateId);
        PhotoAnimerTaskCreateResponse response = client.execute(request);
        return (Long)response.getData();
    }

    public static boolean passportPhoto() throws Exception {
        String base64 = UnitTests.toBASE64(UnitTests.getResources("img/boy.jpg"));
        PassportPhotoRequest request = new PassportPhotoRequest();
        request.setBase64(base64);
        request.setBgColor("3557FF");
        request.setDpi(300);
        request.setMmHeight(49);
        request.setMmWidth(35);
        request.setPrintBgColor("FFFCF9");
        request.setPrintMmHeight(297);
        request.setPrintMmWidth(210);
        request.setDress("woman3");
        PassportPhotoResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean cartoonSelfieToBase64ByUrl() throws Exception {
        CartoonSelfieToBase64ByUrlRequest request = new CartoonSelfieToBase64ByUrlRequest();
        request.setUrl(manUrl);
        request.setCartoonType(3);
        CartoonSelfieToBase64ByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean cartoonSelfieToBase64ByFile() throws Exception {
        CartoonSelfieToBase64ByFileRequest request = new CartoonSelfieToBase64ByFileRequest();
        request.setFile(UnitTests.getResources("img/boy.jpg"));
        request.setCartoonType(3);
        CartoonSelfieToBase64ByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean cartoonSelfieToByteByFile(int cartoonType) throws Exception {
        CartoonSelfieToByteByFileRequest request = new CartoonSelfieToByteByFileRequest();
        request.setFile(UnitTests.getResources("img/boy.jpg"));
        request.setCartoonType(cartoonType);
        CartoonSelfieToByteByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean imageRetouch() throws Exception {
        String base64 = UnitTests.toBASE64(UnitTests.getResources("img/boy.jpg"));
        ImageRetouchRequest.Rectangle rectangle = new ImageRetouchRequest.Rectangle();
        rectangle.setWidth(100);
        rectangle.setHeight(100);
        rectangle.setX(100);
        rectangle.setY(100);
        ImageRetouchRequest request = new ImageRetouchRequest();
        request.setBase64(base64);
        request.setRectangles(Arrays.asList(rectangle));
        ImageRetouchResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            if ("success".equals(((ImageRetouchResponse.Data)response.getData()).getStatus())) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public static boolean photoColorizerToBase64ByUrl() throws Exception {
        PhotoColorizerToBase64ByUrlRequest request = new PhotoColorizerToBase64ByUrlRequest();
        request.setUrl(grayScaleUrl);
        PhotoColorizerToBase64ByUrlResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean photoColorizerToBase64ByFile() throws Exception {
        PhotoColorizerToBase64ByFileRequest request = new PhotoColorizerToBase64ByFileRequest();
        request.setFile(UnitTests.getResources("img/grayScale.jpg"));
        PhotoColorizerToBase64ByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean photoColorizerToByteByFile() throws Exception {
        PhotoColorizerToByteByFileRequest request = new PhotoColorizerToByteByFileRequest();
        request.setFile(UnitTests.getResources("img/grayScale.jpg"));
        PhotoColorizerToByteByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean faceCutoutToBase64ByUrl() throws Exception {
        FaceCutoutToBase64ByUrlRequest request = new FaceCutoutToBase64ByUrlRequest();
        request.setBgcolor("ffccff");
        request.setUrl(manUrl);
        FaceCutoutToBase64ByUrlResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean faceCutoutToBase64ByFile() throws Exception {
        FaceCutoutToBase64ByFileRequest request = new FaceCutoutToBase64ByFileRequest();
        request.setBgcolor("ffccff");
        request.setFile(UnitTests.getResources("img/boy.jpg"));
        FaceCutoutToBase64ByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean faceCutoutToByteByFile() throws Exception {
        FaceCutoutToByteByFileRequest request = new FaceCutoutToByteByFileRequest();
        request.setBgcolor("ffccff");
        request.setFile(UnitTests.getResources("img/boy.jpg"));
        FaceCutoutToByteByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean photoEnhancerToBase64ByUrl() throws Exception {
        PhotoEnhancerToBase64ByUrlRequest request = new PhotoEnhancerToBase64ByUrlRequest();
        request.setUrl(manUrl);
        PhotoEnhancerToBase64ByUrlResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean photoEnhancerToBase64ByFile() throws Exception {
        PhotoEnhancerToBase64ByFileRequest request = new PhotoEnhancerToBase64ByFileRequest();
        request.setFile(UnitTests.getResources("img/boy.jpg"));
        PhotoEnhancerToBase64ByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean photoEnhancerToByteByFile() throws Exception {
        PhotoEnhancerToByteByFileRequest request = new PhotoEnhancerToByteByFileRequest();
        request.setFile(UnitTests.getResources("img/boy.jpg"));
        PhotoEnhancerToByteByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean removeBackgroundToBase64ByUrl() throws Exception {
        RemoveBackgroundToBase64ByUrlRequest request = new RemoveBackgroundToBase64ByUrlRequest();
        request.setUrl(manUrl);
        RemoveBackgroundToBase64ByUrlResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean removeBackgroundToBase64ByFile() throws Exception {
        RemoveBackgroundToBase64ByFileRequest request = new RemoveBackgroundToBase64ByFileRequest();
        request.setFile(UnitTests.getResources("img/boy.jpg"));
        RemoveBackgroundToBase64ByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean removeBackgroundToByteByFile() throws Exception {
        RemoveBackgroundToByteByFileRequest request = new RemoveBackgroundToByteByFileRequest();
        request.setBgcolor("ffccff");
        request.setFile(UnitTests.getResources("img/boy.jpg"));
        RemoveBackgroundToByteByFileResponse response = client.execute(request);
        if (response.getCode().equals(0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String toBASE64(InputStream inputStream) throws IOException {
        byte[] data = UnitTests.inputTobyte(inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
        BufferedImage bufferedImage = ImageIO.read(imageInputStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String formatName = UnitTests.getImageType(data);
        ImageIO.write((RenderedImage)bufferedImage, formatName, out);
        byte[] bytes = Base64.getEncoder().encode(out.toByteArray());
        return new String(bytes);
    }

    public static byte[] inputTobyte(InputStream inStream) throws IOException {
        int rc;
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        while ((rc = inStream.read(buff, 0, 100)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        return swapStream.toByteArray();
    }

    public static String getImageType(byte[] data) {
        String type = null;
        if (data[1] == 80 && data[2] == 78 && data[3] == 71) {
            type = "PNG";
            return type;
        }
        if (data[0] == 71 && data[1] == 73 && data[2] == 70) {
            type = "GIF";
            return type;
        }
        if (data[6] == 74 && data[7] == 70 && data[8] == 73 && data[9] == 70) {
            type = "JPG";
            return type;
        }
        if (data[6] == 69 && data[7] == 120 && data[8] == 105 && data[9] == 102) {
            type = "JPG";
            return type;
        }
        if (data[8] == 87 && data[9] == 69 && data[10] == 66 && data[11] == 80) {
            type = "WEBP";
            return type;
        }
        if (data[0] == 66 && data[1] == 77 && data[2] == 118 && data[3] == 65) {
            type = "BMP";
            return type;
        }
        return type;
    }

    static {
        cache = new HashMap<String, byte[]>();
    }
}

