/*
 * Decompiled with CFR 0.152.
 */
package pro.cutout.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import pro.cutout.api.ApiBodyField;
import pro.cutout.api.CutoutRequest;
import pro.cutout.api.CutoutResponse;

public class CutoutClient {
    private String apikey;
    private String serverUrl;

    public CutoutClient(String serverUrl, String apiKey) {
        this.serverUrl = serverUrl;
        this.apikey = apiKey;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public <T extends CutoutResponse> T execute(CutoutRequest<T> request) throws Exception {
        HttpUriRequest httpUriRequest = this.getHttpRequest(request);
        httpUriRequest.setHeader("APIKEY", this.apikey);
        try {
            this.check(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            CutoutResponse cutoutResponse = (CutoutResponse)request.getResponseClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            cutoutResponse.setCode(-1);
            cutoutResponse.setMsg(e.getMessage());
            cutoutResponse.setTime(System.currentTimeMillis());
            return (T)cutoutResponse;
        }
        try (CloseableHttpClient client = HttpClients.createDefault();){
            CutoutResponse cutoutResponse;
            block22: {
                CutoutResponse cutoutResponse2;
                CloseableHttpResponse response;
                block20: {
                    CutoutResponse cutoutResponse3;
                    block21: {
                        response = client.execute(httpUriRequest);
                        try {
                            if (response.getStatusLine().getStatusCode() == 200) break block20;
                            CutoutResponse cutoutResponse4 = (CutoutResponse)request.getResponseClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            cutoutResponse4.setCode(-1);
                            cutoutResponse4.setMsg("http status code:" + response.getStatusLine().getStatusCode());
                            cutoutResponse4.setTime(System.currentTimeMillis());
                            cutoutResponse3 = cutoutResponse4;
                            if (response == null) break block21;
                        }
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        response.close();
                    }
                    return (T)cutoutResponse3;
                }
                HttpEntity httpEntity = response.getEntity();
                if (httpEntity.getContentType().getValue().startsWith(ContentType.APPLICATION_JSON.getMimeType())) {
                    String result = EntityUtils.toString((HttpEntity)response.getEntity());
                    cutoutResponse2 = (CutoutResponse)JSON.parseObject((String)result, request.getResponseClass());
                } else {
                    byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                    cutoutResponse2 = (CutoutResponse)request.getResponseClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    cutoutResponse2.setCode(0);
                    cutoutResponse2.setData(bytes);
                    cutoutResponse2.setTime(System.currentTimeMillis());
                }
                cutoutResponse = cutoutResponse2;
                if (response == null) break block22;
                response.close();
            }
            return (T)cutoutResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            CutoutResponse cutoutResponse = (CutoutResponse)request.getResponseClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            cutoutResponse.setCode(-1);
            cutoutResponse.setMsg(e.getMessage());
            cutoutResponse.setTime(System.currentTimeMillis());
            return (T)cutoutResponse;
        }
    }

    public HttpUriRequest getHttpRequest(CutoutRequest cutoutRequest) throws Exception {
        String apiUrl = this.serverUrl + cutoutRequest.getApiUrl();
        ContentType contentType = cutoutRequest.getContentType();
        if ("GET".equals(cutoutRequest.getHttpMethod())) {
            StringBuffer url = new StringBuffer(apiUrl);
            Field[] fields = cutoutRequest.getClass().getDeclaredFields();
            boolean first = !apiUrl.contains("?");
            for (Field field : fields) {
                field.setAccessible(true);
                Object value = field.get(cutoutRequest);
                if (value == null) continue;
                if (first) {
                    first = false;
                    url.append("?");
                } else {
                    url.append("&");
                }
                ApiBodyField bodyField = field.getAnnotation(ApiBodyField.class);
                if (bodyField == null) {
                    url.append(field.getName());
                    url.append("=");
                    url.append(value);
                    continue;
                }
                String fieldName = bodyField.fieldName();
                String name = fieldName != null && !fieldName.isEmpty() ? fieldName : field.getName();
                url.append(name);
                url.append("=");
                url.append(value);
            }
            HttpGet httpGet = new HttpGet(url.toString());
            return httpGet;
        }
        HttpPost httpPost = new HttpPost(apiUrl);
        if (ContentType.APPLICATION_JSON.equals(contentType)) {
            String content = JSONObject.toJSONString((Object)cutoutRequest);
            StringEntity stringEntity = new StringEntity(content, "UTF-8");
            stringEntity.setContentType(ContentType.APPLICATION_JSON.toString());
            httpPost.setEntity((HttpEntity)stringEntity);
        } else if (ContentType.MULTIPART_FORM_DATA.equals(contentType)) {
            Field[] fields;
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.setContentType(contentType);
            for (Field field : fields = cutoutRequest.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                ApiBodyField bodyField = field.getAnnotation(ApiBodyField.class);
                String name = field.getName();
                Object value = field.get(cutoutRequest);
                if (bodyField != null) {
                    String fieldName = bodyField.fieldName();
                    String string = name = fieldName != null && !fieldName.isEmpty() ? bodyField.fieldName() : name;
                    if (value == null) {
                        value = bodyField.value();
                    }
                }
                if (value == null) continue;
                if (value instanceof InputStream) {
                    multipartEntityBuilder.addBinaryBody(name, (InputStream)value);
                    continue;
                }
                if (value instanceof File) {
                    multipartEntityBuilder.addBinaryBody(name, (File)value);
                    continue;
                }
                if (value instanceof byte[]) {
                    multipartEntityBuilder.addBinaryBody(name, (byte[])value);
                    continue;
                }
                multipartEntityBuilder.addTextBody(name, value.toString());
            }
            httpPost.setEntity(multipartEntityBuilder.build());
        }
        return httpPost;
    }

    private <T extends CutoutResponse> void check(CutoutRequest<T> request) {
    }
}

