/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.result;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.type.ObjectTypeHandler;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.ibatis.type.UnknownTypeHandler;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.delegate.R2dbcMybatisConfiguration;

public class RowResultWrapper {
    private final Row row;
    private final RowMetadata rowMetadata;
    private final TypeHandlerRegistry typeHandlerRegistry;
    private final List<String> columnNames = new ArrayList<String>();
    private final List<Class> javaTypes = new ArrayList<Class>();
    private final List<String> classNames = new ArrayList<String>();
    private final Map<String, Map<Class<?>, TypeHandler<?>>> typeHandlerMap = new HashMap();
    private final Map<String, List<String>> mappedColumnNamesMap = new HashMap<String, List<String>>();
    private final Map<String, List<String>> unMappedColumnNamesMap = new HashMap<String, List<String>>();

    public RowResultWrapper(Row row, RowMetadata rowMetadata, R2dbcMybatisConfiguration configuration) {
        this.typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        this.row = row;
        this.rowMetadata = rowMetadata;
        rowMetadata.getColumnMetadatas().forEach(columnMetadata -> {
            this.columnNames.add(columnMetadata.getName());
            Class<Object> javaType = columnMetadata.getJavaType();
            if (null == javaType) {
                javaType = Object.class;
            }
            this.javaTypes.add(javaType);
            this.classNames.add(javaType.getSimpleName());
        });
    }

    public Row getRow() {
        return this.row;
    }

    public RowMetadata getRowMetadata() {
        return this.rowMetadata;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<String> getClassNames() {
        return Collections.unmodifiableList(this.classNames);
    }

    public List<Class> getJavaTypes() {
        return this.javaTypes;
    }

    public TypeHandler<?> getTypeHandler(Class<?> propertyType, String columnName) {
        TypeHandler handler = null;
        Map<Class<?>, TypeHandler<?>> columnHandlers = this.typeHandlerMap.get(columnName);
        if (columnHandlers == null) {
            columnHandlers = new HashMap();
            this.typeHandlerMap.put(columnName, columnHandlers);
        } else {
            handler = columnHandlers.get(propertyType);
        }
        if (handler == null) {
            int index;
            Class<?> javaType;
            handler = this.typeHandlerRegistry.getTypeHandler(propertyType, null);
            if ((handler == null || handler instanceof UnknownTypeHandler) && (javaType = this.resolveClass(this.classNames.get(index = this.columnNames.indexOf(columnName)))) != null) {
                handler = this.typeHandlerRegistry.getTypeHandler(javaType);
            }
            if (handler == null || handler instanceof UnknownTypeHandler) {
                handler = new ObjectTypeHandler();
            }
            columnHandlers.put(propertyType, handler);
        }
        return handler;
    }

    private Class<?> resolveClass(String className) {
        try {
            if (className != null) {
                return Resources.classForName((String)className);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private void loadMappedAndUnmappedColumnNames(ResultMap resultMap, String columnPrefix) {
        ArrayList<String> mappedColumnNames = new ArrayList<String>();
        ArrayList<String> unmappedColumnNames = new ArrayList<String>();
        String upperColumnPrefix = columnPrefix == null ? null : columnPrefix.toUpperCase(Locale.ENGLISH);
        Set<String> mappedColumns = this.prependPrefixes(resultMap.getMappedColumns(), upperColumnPrefix);
        for (String columnName : this.columnNames) {
            String upperColumnName = columnName.toUpperCase(Locale.ENGLISH);
            if (mappedColumns.contains(upperColumnName)) {
                mappedColumnNames.add(upperColumnName);
                continue;
            }
            unmappedColumnNames.add(columnName);
        }
        this.mappedColumnNamesMap.put(this.getMapKey(resultMap, columnPrefix), mappedColumnNames);
        this.unMappedColumnNamesMap.put(this.getMapKey(resultMap, columnPrefix), unmappedColumnNames);
    }

    public List<String> getMappedColumnNames(ResultMap resultMap, String columnPrefix) {
        List<String> mappedColumnNames = this.mappedColumnNamesMap.get(this.getMapKey(resultMap, columnPrefix));
        if (mappedColumnNames == null) {
            this.loadMappedAndUnmappedColumnNames(resultMap, columnPrefix);
            mappedColumnNames = this.mappedColumnNamesMap.get(this.getMapKey(resultMap, columnPrefix));
        }
        return mappedColumnNames;
    }

    public List<String> getUnmappedColumnNames(ResultMap resultMap, String columnPrefix) {
        List<String> unMappedColumnNames = this.unMappedColumnNamesMap.get(this.getMapKey(resultMap, columnPrefix));
        if (unMappedColumnNames == null) {
            this.loadMappedAndUnmappedColumnNames(resultMap, columnPrefix);
            unMappedColumnNames = this.unMappedColumnNamesMap.get(this.getMapKey(resultMap, columnPrefix));
        }
        return unMappedColumnNames;
    }

    private String getMapKey(ResultMap resultMap, String columnPrefix) {
        return resultMap.getId() + ":" + columnPrefix;
    }

    private Set<String> prependPrefixes(Set<String> columnNames, String prefix) {
        if (columnNames == null || columnNames.isEmpty() || prefix == null || prefix.length() == 0) {
            return columnNames == null ? Collections.emptySet() : columnNames;
        }
        HashSet<String> prefixed = new HashSet<String>();
        for (String columnName : columnNames) {
            prefixed.add(prefix + columnName);
        }
        return prefixed;
    }
}

