/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.defaults;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.r2dbc.spi.ConnectionMetadata;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.util.MapUtil;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.PlaceholderDialect;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.PlaceholderDialectRegistry;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.PlaceholderFormatter;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.support.ReactiveExecutorContextAttribute;

public class DefaultPlaceholderFormatter
implements PlaceholderFormatter {
    private static final Log log = LogFactory.getLog(DefaultPlaceholderFormatter.class);
    private final PlaceholderDialectRegistry placeholderDialectRegistry;
    private final ConcurrentHashMap<Class<? extends PlaceholderDialect>, Cache<String, String>> formattedSqlCache = new ConcurrentHashMap();

    public DefaultPlaceholderFormatter(PlaceholderDialectRegistry placeholderDialectRegistry, Integer sqlCacheMaxSize, Duration sqlCacheExpireDuration) {
        this.placeholderDialectRegistry = placeholderDialectRegistry;
        Set<Class<? extends PlaceholderDialect>> allPlaceholderDialectTypes = placeholderDialectRegistry.getAllPlaceholderDialectTypes();
        for (Class<? extends PlaceholderDialect> placeholderDialectType : allPlaceholderDialectTypes) {
            Cache cache = Caffeine.newBuilder().maximumSize((long)sqlCacheMaxSize.intValue()).expireAfterAccess(sqlCacheExpireDuration).initialCapacity(10).build();
            this.formattedSqlCache.put(placeholderDialectType, (Cache<String, String>)cache);
        }
    }

    @Override
    public String replaceSqlPlaceholder(ConnectionMetadata connectionMetadata, BoundSql boundSql, ReactiveExecutorContextAttribute reactiveExecutorContextAttribute) {
        Optional<PlaceholderDialect> optionalPlaceholderDialect = this.placeholderDialectRegistry.getPlaceholderDialect(connectionMetadata, reactiveExecutorContextAttribute).filter(placeholderDialect -> !Objects.equals(placeholderDialect.getMarker(), "?"));
        String originalSql = boundSql.getSql();
        if (!optionalPlaceholderDialect.isPresent()) {
            if (log.isTraceEnabled()) {
                log.trace("Placeholder dialect not found or is default placeholder ,use original sql");
            }
            return originalSql;
        }
        PlaceholderDialect placeholderDialect2 = optionalPlaceholderDialect.get();
        Cache<String, String> cache = this.formattedSqlCache.get(placeholderDialect2.getClass());
        if (Objects.isNull(cache)) {
            throw new IllegalStateException("Placeholder dialect found,but Placeholder dialect sql cache is null,Placeholder dialect type : " + placeholderDialect2.getClass());
        }
        return (String)MapUtil.computeIfAbsent((Map)cache.asMap(), (Object)originalSql, statementId -> this.formatPlaceholderInternal(placeholderDialect2, boundSql));
    }

    protected String formatPlaceholderInternal(PlaceholderDialect placeholderDialect, BoundSql boundSql) {
        char defaultPlaceholder;
        String sql = boundSql.getSql();
        if (sql.indexOf(defaultPlaceholder = "?".charAt(0)) < 0) {
            if (log.isTraceEnabled()) {
                log.trace("Placeholder not found ,use original sql");
            }
            return sql;
        }
        int length = sql.length();
        String marker = placeholderDialect.getMarker();
        List parameterMappings = boundSql.getParameterMappings();
        int identifierIndex = placeholderDialect.usingIndexMarker() ? placeholderDialect.startIndex() : 0;
        StringBuilder builder = new StringBuilder(length + 10);
        int begin = 0;
        for (int i = 0; i < length; ++i) {
            boolean forwardMatched;
            char aChar = sql.charAt(i);
            if (aChar != defaultPlaceholder) continue;
            boolean previousMatched = i != 0 && sql.charAt(i - 1) == defaultPlaceholder;
            boolean bl = forwardMatched = i < length - 1 && sql.charAt(i + 1) == defaultPlaceholder;
            if (previousMatched || forwardMatched) continue;
            if (placeholderDialect.usingIndexMarker()) {
                builder.append(sql, begin, i).append(marker).append(identifierIndex);
            } else {
                String parameterProperty = ((ParameterMapping)parameterMappings.get(identifierIndex)).getProperty().replaceAll("\\.", "_");
                builder.append(sql, begin, i).append(marker).append(parameterProperty);
            }
            ++identifierIndex;
            begin = i + 1;
        }
        if (begin != length) {
            builder.append(sql, begin, length);
        }
        if (log.isDebugEnabled()) {
            if (placeholderDialect.usingIndexMarker()) {
                log.debug("Format placeholder based by index, with (" + placeholderDialect.getClass().getSimpleName() + ")");
            } else {
                log.debug("Format placeholder based on parameter name, with (" + placeholderDialect.getClass().getSimpleName() + ")");
            }
            log.debug("Formatted SQL  => " + builder);
        }
        return builder.toString();
    }
}

