/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.result.handler;

import io.r2dbc.spi.Row;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ibatis.annotations.AutomapConstructor;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.executor.result.DefaultResultHandler;
import org.apache.ibatis.executor.result.ResultMapException;
import org.apache.ibatis.mapping.Discriminator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.ibatis.util.MapUtil;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.delegate.R2dbcMybatisConfiguration;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.exception.R2dbcResultException;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.result.RowResultWrapper;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.result.TypeHandleContext;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.result.handler.DelegateR2dbcResultRowDataHandler;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.result.handler.ReactiveResultHandler;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.support.ProxyInstanceFactory;

public class DefaultReactiveResultHandler
implements ReactiveResultHandler {
    private final LongAdder totalCount = new LongAdder();
    private final R2dbcMybatisConfiguration r2DbcMybatisConfiguration;
    private final MappedStatement mappedStatement;
    private final ObjectFactory objectFactory;
    private final ReflectorFactory reflectorFactory;
    private final TypeHandlerRegistry typeHandlerRegistry;
    private final Map<CacheKey, List<PendingRelation>> pendingRelations = new HashMap<CacheKey, List<PendingRelation>>();
    private final Map<String, List<UnMappedColumnAutoMapping>> autoMappingsCache = new HashMap<String, List<UnMappedColumnAutoMapping>>();
    private final Map<String, List<String>> constructorAutoMappingColumns = new HashMap<String, List<String>>();
    private final Map<CacheKey, Object> nestedResultObjects = new HashMap<CacheKey, Object>();
    private final Map<String, Object> ancestorObjects = new HashMap<String, Object>();
    private final TypeHandler delegatedTypeHandler;
    private final List<Object> resultHolder = new ArrayList<Object>();
    private boolean useConstructorMappings;
    private Object previousRowValue;

    public DefaultReactiveResultHandler(R2dbcMybatisConfiguration r2DbcMybatisConfiguration, MappedStatement mappedStatement) {
        this.mappedStatement = mappedStatement;
        this.r2DbcMybatisConfiguration = r2DbcMybatisConfiguration;
        this.objectFactory = r2DbcMybatisConfiguration.getObjectFactory();
        this.reflectorFactory = r2DbcMybatisConfiguration.getReflectorFactory();
        this.typeHandlerRegistry = r2DbcMybatisConfiguration.getTypeHandlerRegistry();
        this.delegatedTypeHandler = this.initDelegateTypeHandler();
    }

    @Override
    public Integer getResultRowTotalCount() {
        return this.totalCount.intValue();
    }

    @Override
    public <T> List<T> handleResult(RowResultWrapper rowResultWrapper) {
        List resultMaps = this.mappedStatement.getResultMaps();
        int resultMapCount = resultMaps.size();
        if (resultMapCount < 1) {
            throw new ExecutorException("A query was run and no Result Maps were found for the Mapped Statement '" + this.mappedStatement.getId() + "'.  It's likely that neither a Result Type nor a Result Map was specified.");
        }
        ResultMap resultMap = (ResultMap)resultMaps.get(0);
        if (!resultMap.hasNestedResultMaps()) {
            try {
                ResultMap discriminatedResultMap = this.resolveDiscriminatedResultMap(rowResultWrapper, resultMap, null);
                Object rowValue = this.getRowValueForSimpleResultMap(rowResultWrapper, discriminatedResultMap, null);
                this.totalCount.increment();
                return Collections.singletonList(rowValue);
            }
            catch (SQLException e) {
                throw new R2dbcResultException(e);
            }
        }
        try {
            List<Object> objects = this.handleRowValuesForNestedResultMap(rowResultWrapper, resultMap);
            this.totalCount.increment();
            return objects;
        }
        catch (SQLException e) {
            throw new R2dbcResultException(e);
        }
    }

    @Override
    public <T> List<T> getRemainedResults() {
        return this.resultHolder;
    }

    private Object getRowValueForSimpleResultMap(RowResultWrapper rowResultWrapper, ResultMap resultMap, String columnPrefix) throws SQLException {
        Object rowValue = this.createResultObject(rowResultWrapper, resultMap, columnPrefix);
        if (rowValue != null && !this.hasTypeHandlerForResultObject(resultMap.getType())) {
            MetaObject metaObject = this.r2DbcMybatisConfiguration.newMetaObject(rowValue);
            boolean foundValues = this.useConstructorMappings;
            if (this.shouldApplyAutomaticMappings(resultMap, false)) {
                foundValues = this.applyAutomaticMappings(rowResultWrapper, resultMap, metaObject, columnPrefix) || foundValues;
            }
            foundValues = this.applyPropertyMappings(rowResultWrapper, resultMap, metaObject, columnPrefix) || foundValues;
            rowValue = foundValues || this.r2DbcMybatisConfiguration.isReturnInstanceForEmptyRow() ? rowValue : null;
        }
        return rowValue;
    }

    private List<Object> handleRowValuesForNestedResultMap(RowResultWrapper rowResultWrapper, ResultMap resultMap) throws SQLException {
        DefaultResultHandler resultHandler = new DefaultResultHandler(this.objectFactory);
        DefaultResultContext resultContext = new DefaultResultContext();
        Object rowValue = this.previousRowValue;
        ResultMap discriminatedResultMap = this.resolveDiscriminatedResultMap(rowResultWrapper, resultMap, null);
        CacheKey rowKey = this.createRowKey(discriminatedResultMap, rowResultWrapper, null);
        Object partialObject = this.nestedResultObjects.get(rowKey);
        if (this.mappedStatement.isResultOrdered()) {
            if (partialObject == null && rowValue != null) {
                this.nestedResultObjects.clear();
                this.storeObject((ResultHandler<?>)resultHandler, (DefaultResultContext<Object>)resultContext, rowValue, null, rowResultWrapper);
            }
            rowValue = this.getRowValueForNestedResultMap(rowResultWrapper, discriminatedResultMap, rowKey, null, partialObject);
        } else {
            rowValue = this.getRowValueForNestedResultMap(rowResultWrapper, discriminatedResultMap, rowKey, null, partialObject);
            if (partialObject == null) {
                this.storeObject((ResultHandler<?>)resultHandler, (DefaultResultContext<Object>)resultContext, rowValue, null, rowResultWrapper);
            }
        }
        if (rowValue != null && this.mappedStatement.isResultOrdered()) {
            this.storeObject((ResultHandler<?>)resultHandler, (DefaultResultContext<Object>)resultContext, rowValue, null, rowResultWrapper);
            this.previousRowValue = null;
        } else if (rowValue != null) {
            this.previousRowValue = rowValue;
        }
        List resultList = resultHandler.getResultList();
        if (resultList != null && !resultList.isEmpty()) {
            this.resultHolder.addAll(resultList);
        }
        return Collections.singletonList(DEFERRED);
    }

    private boolean applyNestedResultMappings(RowResultWrapper rowResultWrapper, ResultMap resultMap, MetaObject metaObject, String parentPrefix, CacheKey parentRowKey, boolean newObject) {
        boolean foundValues = false;
        for (ResultMapping resultMapping : resultMap.getPropertyResultMappings()) {
            String nestedResultMapId = resultMapping.getNestedResultMapId();
            if (nestedResultMapId == null || resultMapping.getResultSet() != null) continue;
            try {
                Object ancestorObject;
                String columnPrefix = this.getColumnPrefix(parentPrefix, resultMapping);
                ResultMap nestedResultMap = this.getNestedResultMap(rowResultWrapper, nestedResultMapId, columnPrefix);
                if (resultMapping.getColumnPrefix() == null && (ancestorObject = this.ancestorObjects.get(nestedResultMapId)) != null) {
                    if (!newObject) continue;
                    this.linkObjects(metaObject, resultMapping, ancestorObject);
                    continue;
                }
                CacheKey rowKey = this.createRowKey(nestedResultMap, rowResultWrapper, columnPrefix);
                CacheKey combinedKey = this.combineKeys(rowKey, parentRowKey);
                Object rowValue = this.nestedResultObjects.get(combinedKey);
                boolean knownValue = rowValue != null;
                this.instantiateCollectionPropertyIfAppropriate(resultMapping, metaObject);
                if (!this.anyNotNullColumnHasValue(resultMapping, columnPrefix, rowResultWrapper) || (rowValue = this.getRowValueForNestedResultMap(rowResultWrapper, nestedResultMap, combinedKey, columnPrefix, rowValue)) == null || knownValue) continue;
                this.linkObjects(metaObject, resultMapping, rowValue);
                foundValues = true;
            }
            catch (SQLException e) {
                throw new ExecutorException("Error getting nested result map values for '" + resultMapping.getProperty() + "'.  Cause: " + e, (Throwable)e);
            }
        }
        return foundValues;
    }

    private Object getRowValueForNestedResultMap(RowResultWrapper rowResultWrapper, ResultMap resultMap, CacheKey combinedKey, String columnPrefix, Object partialObject) throws SQLException {
        String resultMapId = resultMap.getId();
        Object rowValue = partialObject;
        if (rowValue != null) {
            MetaObject metaObject = this.r2DbcMybatisConfiguration.newMetaObject(rowValue);
            this.putAncestor(rowValue, resultMapId);
            this.applyNestedResultMappings(rowResultWrapper, resultMap, metaObject, columnPrefix, combinedKey, false);
            this.ancestorObjects.remove(resultMapId);
        } else {
            rowValue = this.createResultObject(rowResultWrapper, resultMap, columnPrefix);
            if (rowValue != null && !this.hasTypeHandlerForResultObject(resultMap.getType())) {
                MetaObject metaObject = this.r2DbcMybatisConfiguration.newMetaObject(rowValue);
                boolean foundValues = this.useConstructorMappings;
                if (this.shouldApplyAutomaticMappings(resultMap, true)) {
                    foundValues = this.applyAutomaticMappings(rowResultWrapper, resultMap, metaObject, columnPrefix) || foundValues;
                }
                foundValues = this.applyPropertyMappings(rowResultWrapper, resultMap, metaObject, columnPrefix) || foundValues;
                this.putAncestor(rowValue, resultMapId);
                foundValues = this.applyNestedResultMappings(rowResultWrapper, resultMap, metaObject, columnPrefix, combinedKey, true) || foundValues;
                this.ancestorObjects.remove(resultMapId);
                Object object = rowValue = foundValues || this.r2DbcMybatisConfiguration.isReturnInstanceForEmptyRow() ? rowValue : null;
            }
            if (combinedKey != CacheKey.NULL_CACHE_KEY) {
                this.nestedResultObjects.put(combinedKey, rowValue);
            }
        }
        return rowValue;
    }

    private boolean applyPropertyMappings(RowResultWrapper rowResultWrapper, ResultMap resultMap, MetaObject metaObject, String columnPrefix) throws SQLException {
        List<String> mappedColumnNames = rowResultWrapper.getMappedColumnNames(resultMap, columnPrefix);
        boolean foundValues = false;
        List propertyMappings = resultMap.getPropertyResultMappings();
        for (ResultMapping propertyMapping : propertyMappings) {
            String column = this.prependPrefix(propertyMapping.getColumn(), columnPrefix);
            if (propertyMapping.getNestedResultMapId() != null) {
                column = null;
            }
            if (!propertyMapping.isCompositeResult() && (column == null || !mappedColumnNames.contains(column.toUpperCase(Locale.ENGLISH))) && propertyMapping.getResultSet() == null) continue;
            Object value = this.getPropertyMappingValue(rowResultWrapper, metaObject, propertyMapping, columnPrefix);
            String property = propertyMapping.getProperty();
            if (property == null) continue;
            if (value == DEFERRED) {
                foundValues = true;
                continue;
            }
            if (value != null) {
                foundValues = true;
            }
            if (value == null && (!this.r2DbcMybatisConfiguration.isCallSettersOnNulls() || metaObject.getSetterType(property).isPrimitive())) continue;
            metaObject.setValue(property, value);
        }
        return foundValues;
    }

    private Object getPropertyMappingValue(RowResultWrapper rowResultWrapper, MetaObject metaResultObject, ResultMapping propertyMapping, String columnPrefix) throws SQLException {
        if (propertyMapping.getNestedQueryId() != null) {
            throw new UnsupportedOperationException("Not supported Nested query ");
        }
        TypeHandler typeHandler = propertyMapping.getTypeHandler();
        String column = this.prependPrefix(propertyMapping.getColumn(), columnPrefix);
        ((TypeHandleContext)this.delegatedTypeHandler).contextWith(typeHandler, rowResultWrapper);
        return this.delegatedTypeHandler.getResult(null, column);
    }

    private List<UnMappedColumnAutoMapping> createAutomaticMappings(RowResultWrapper rowResultWrapper, ResultMap resultMap, MetaObject metaObject, String columnPrefix) throws SQLException {
        String mapKey = resultMap.getId() + ":" + columnPrefix;
        List<UnMappedColumnAutoMapping> autoMapping = this.autoMappingsCache.get(mapKey);
        if (autoMapping == null) {
            autoMapping = new ArrayList<UnMappedColumnAutoMapping>();
            List<String> unmappedColumnNames = rowResultWrapper.getUnmappedColumnNames(resultMap, columnPrefix);
            List<String> mappedInConstructorAutoMapping = this.constructorAutoMappingColumns.remove(mapKey);
            if (mappedInConstructorAutoMapping != null) {
                unmappedColumnNames.removeAll(mappedInConstructorAutoMapping);
            }
            Iterator<String> iterator = unmappedColumnNames.iterator();
            while (iterator.hasNext()) {
                String property;
                String columnName;
                String propertyName = columnName = iterator.next();
                if (columnPrefix != null && !columnPrefix.isEmpty()) {
                    if (!columnName.toUpperCase(Locale.ENGLISH).startsWith(columnPrefix)) continue;
                    propertyName = columnName.substring(columnPrefix.length());
                }
                if ((property = metaObject.findProperty(propertyName, this.r2DbcMybatisConfiguration.isMapUnderscoreToCamelCase())) != null && metaObject.hasSetter(property)) {
                    if (resultMap.getMappedProperties().contains(property)) continue;
                    Class propertyType = metaObject.getSetterType(property);
                    if (this.typeHandlerRegistry.hasTypeHandler(propertyType)) {
                        TypeHandler<?> typeHandler = rowResultWrapper.getTypeHandler(propertyType, columnName);
                        autoMapping.add(new UnMappedColumnAutoMapping(columnName, property, typeHandler, propertyType.isPrimitive()));
                        continue;
                    }
                    this.r2DbcMybatisConfiguration.getAutoMappingUnknownColumnBehavior().doAction(this.mappedStatement, columnName, property, propertyType);
                    continue;
                }
                this.r2DbcMybatisConfiguration.getAutoMappingUnknownColumnBehavior().doAction(this.mappedStatement, columnName, property != null ? property : propertyName, null);
            }
            this.autoMappingsCache.put(mapKey, autoMapping);
        }
        return autoMapping;
    }

    private boolean applyAutomaticMappings(RowResultWrapper rowResultWrapper, ResultMap resultMap, MetaObject metaObject, String columnPrefix) throws SQLException {
        List<UnMappedColumnAutoMapping> autoMapping = this.createAutomaticMappings(rowResultWrapper, resultMap, metaObject, columnPrefix);
        boolean foundValues = false;
        if (!autoMapping.isEmpty()) {
            for (UnMappedColumnAutoMapping mapping : autoMapping) {
                TypeHandler typeHandler = mapping.typeHandler;
                ((TypeHandleContext)this.delegatedTypeHandler).contextWith(typeHandler, rowResultWrapper);
                Object value = this.delegatedTypeHandler.getResult(null, mapping.column);
                if (value != null) {
                    foundValues = true;
                }
                if (value == null && (!this.r2DbcMybatisConfiguration.isCallSettersOnNulls() || mapping.primitive)) continue;
                metaObject.setValue(mapping.property, value);
            }
        }
        return foundValues;
    }

    private Object createResultObject(RowResultWrapper rowResultWrapper, ResultMap resultMap, String columnPrefix) throws SQLException {
        this.useConstructorMappings = false;
        ArrayList constructorArgTypes = new ArrayList();
        ArrayList<Object> constructorArgs = new ArrayList<Object>();
        Object resultObject = this.createResultObject(rowResultWrapper, resultMap, constructorArgTypes, constructorArgs, columnPrefix);
        this.useConstructorMappings = resultObject != null && !constructorArgTypes.isEmpty();
        return resultObject;
    }

    private Object createResultObject(RowResultWrapper rowResultWrapper, ResultMap resultMap, List<Class<?>> constructorArgTypes, List<Object> constructorArgs, String columnPrefix) throws SQLException {
        Class resultType = resultMap.getType();
        MetaClass metaType = MetaClass.forClass((Class)resultType, (ReflectorFactory)this.reflectorFactory);
        List constructorMappings = resultMap.getConstructorResultMappings();
        if (this.hasTypeHandlerForResultObject(resultType)) {
            return this.createPrimitiveResultObject(rowResultWrapper, resultMap, columnPrefix);
        }
        if (!constructorMappings.isEmpty()) {
            return this.createParameterizedResultObject(rowResultWrapper, resultType, constructorMappings, constructorArgTypes, constructorArgs, columnPrefix);
        }
        if (resultType.isInterface() || metaType.hasDefaultConstructor()) {
            return this.objectFactory.create(resultType);
        }
        if (this.shouldApplyAutomaticMappings(resultMap, false)) {
            return this.createByConstructorSignature(rowResultWrapper, resultMap, columnPrefix, resultType, constructorArgTypes, constructorArgs);
        }
        throw new ExecutorException("Do not know how to create an instance of " + resultType);
    }

    private Object createParameterizedResultObject(RowResultWrapper rowResultWrapper, Class<?> resultType, List<ResultMapping> constructorMappings, List<Class<?>> constructorArgTypes, List<Object> constructorArgs, String columnPrefix) {
        boolean foundValues = false;
        for (ResultMapping constructorMapping : constructorMappings) {
            Object value;
            Class parameterType = constructorMapping.getJavaType();
            String column = constructorMapping.getColumn();
            try {
                if (constructorMapping.getNestedQueryId() != null) {
                    throw new UnsupportedOperationException("Unsupported constructor with nested query :" + constructorMapping.getNestedQueryId());
                }
                if (constructorMapping.getNestedResultMapId() != null) {
                    ResultMap resultMap = this.r2DbcMybatisConfiguration.getResultMap(constructorMapping.getNestedResultMapId());
                    value = this.getRowValueForSimpleResultMap(rowResultWrapper, resultMap, this.getColumnPrefix(columnPrefix, constructorMapping));
                } else {
                    TypeHandler typeHandler = constructorMapping.getTypeHandler();
                    ((TypeHandleContext)this.delegatedTypeHandler).contextWith(typeHandler, rowResultWrapper);
                    value = this.delegatedTypeHandler.getResult(null, this.prependPrefix(column, columnPrefix));
                }
            }
            catch (SQLException | ResultMapException e) {
                throw new ExecutorException("Could not process result for mapping: " + constructorMapping, e);
            }
            constructorArgTypes.add(parameterType);
            constructorArgs.add(value);
            foundValues = value != null || foundValues;
        }
        return foundValues ? this.objectFactory.create(resultType, constructorArgTypes, constructorArgs) : null;
    }

    private Object createByConstructorSignature(RowResultWrapper rowResultWrapper, ResultMap resultMap, String columnPrefix, Class<?> resultType, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) throws SQLException {
        return this.applyConstructorAutomapping(rowResultWrapper, resultMap, columnPrefix, resultType, constructorArgTypes, constructorArgs, this.findConstructorForAutomapping(resultType).orElseThrow(() -> new ExecutorException("No constructor found in " + resultType.getName() + " matching " + rowResultWrapper.getClassNames())));
    }

    private Optional<Constructor<?>> findConstructorForAutomapping(Class<?> resultType) {
        Constructor<?>[] constructors = resultType.getDeclaredConstructors();
        if (constructors.length == 1) {
            return Optional.of(constructors[0]);
        }
        Optional<Constructor<?>> annotated = Arrays.stream(constructors).filter(x -> x.isAnnotationPresent(AutomapConstructor.class)).reduce((x, y) -> {
            throw new ExecutorException("@AutomapConstructor should be used in only one constructor.");
        });
        if (annotated.isPresent()) {
            return annotated;
        }
        if (this.r2DbcMybatisConfiguration.isArgNameBasedConstructorAutoMapping()) {
            throw new ExecutorException(MessageFormat.format("'argNameBasedConstructorAutoMapping' is enabled and the class ''{0}'' has multiple constructors, so @AutomapConstructor must be added to one of the constructors.", resultType.getName()));
        }
        return Arrays.stream(constructors).filter(this::findUsableConstructorByArgTypes).findAny();
    }

    private boolean findUsableConstructorByArgTypes(Constructor<?> constructor) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (this.typeHandlerRegistry.hasTypeHandler(parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    private Object applyConstructorAutomapping(RowResultWrapper rowResultWrapper, ResultMap resultMap, String columnPrefix, Class<?> resultType, List<Class<?>> constructorArgTypes, List<Object> constructorArgs, Constructor<?> constructor) throws SQLException {
        boolean foundValues = false;
        foundValues = this.r2DbcMybatisConfiguration.isArgNameBasedConstructorAutoMapping() ? this.applyArgNameBasedConstructorAutoMapping(rowResultWrapper, resultMap, columnPrefix, constructorArgTypes, constructorArgs, constructor, foundValues) : this.applyColumnOrderBasedConstructorAutomapping(rowResultWrapper, constructorArgTypes, constructorArgs, constructor, foundValues);
        return foundValues ? this.objectFactory.create(resultType, constructorArgTypes, constructorArgs) : null;
    }

    private boolean applyColumnOrderBasedConstructorAutomapping(RowResultWrapper rowResultWrapper, List<Class<?>> constructorArgTypes, List<Object> constructorArgs, Constructor<?> constructor, boolean foundValues) throws SQLException {
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            Class<?> parameterType = constructor.getParameterTypes()[i];
            String columnName = rowResultWrapper.getColumnNames().get(i);
            TypeHandler<?> typeHandler = rowResultWrapper.getTypeHandler(parameterType, columnName);
            ((TypeHandleContext)this.delegatedTypeHandler).contextWith(typeHandler, rowResultWrapper);
            Object value = this.delegatedTypeHandler.getResult(null, columnName);
            constructorArgTypes.add(parameterType);
            constructorArgs.add(value);
            foundValues = value != null || foundValues;
        }
        return foundValues;
    }

    private boolean applyArgNameBasedConstructorAutoMapping(RowResultWrapper rowResultWrapper, ResultMap resultMap, String columnPrefix, List<Class<?>> constructorArgTypes, List<Object> constructorArgs, Constructor<?> constructor, boolean foundValues) throws SQLException {
        Parameter[] params;
        ArrayList<String> missingArgs = null;
        for (Parameter param : params = constructor.getParameters()) {
            boolean columnNotFound = true;
            Param paramAnno = param.getAnnotation(Param.class);
            String paramName = paramAnno == null ? param.getName() : paramAnno.value();
            for (String columnName : rowResultWrapper.getColumnNames()) {
                if (!this.columnMatchesParam(columnName, paramName, columnPrefix)) continue;
                Class<?> paramType = param.getType();
                TypeHandler<?> typeHandler = rowResultWrapper.getTypeHandler(paramType, columnName);
                ((TypeHandleContext)this.delegatedTypeHandler).contextWith(typeHandler, rowResultWrapper);
                Object value = this.delegatedTypeHandler.getResult(null, columnName);
                constructorArgTypes.add(paramType);
                constructorArgs.add(value);
                String mapKey = resultMap.getId() + ":" + columnPrefix;
                if (!this.autoMappingsCache.containsKey(mapKey)) {
                    ((List)MapUtil.computeIfAbsent(this.constructorAutoMappingColumns, (Object)mapKey, k -> new ArrayList())).add(columnName);
                }
                columnNotFound = false;
                foundValues = value != null || foundValues;
            }
            if (!columnNotFound) continue;
            if (missingArgs == null) {
                missingArgs = new ArrayList<String>();
            }
            missingArgs.add(paramName);
        }
        if (foundValues && constructorArgs.size() < params.length) {
            throw new ExecutorException(MessageFormat.format("Constructor auto-mapping of ''{1}'' failed because ''{0}'' were not found in the result set; Available columns are ''{2}'' and mapUnderscoreToCamelCase is ''{3}''.", missingArgs, constructor, rowResultWrapper.getColumnNames(), this.r2DbcMybatisConfiguration.isMapUnderscoreToCamelCase()));
        }
        return foundValues;
    }

    private boolean columnMatchesParam(String columnName, String paramName, String columnPrefix) {
        if (columnPrefix != null) {
            if (!columnName.toUpperCase(Locale.ENGLISH).startsWith(columnPrefix)) {
                return false;
            }
            columnName = columnName.substring(columnPrefix.length());
        }
        return paramName.equalsIgnoreCase(this.r2DbcMybatisConfiguration.isMapUnderscoreToCamelCase() ? columnName.replace("_", "") : columnName);
    }

    private Object createPrimitiveResultObject(RowResultWrapper rowResultWrapper, ResultMap resultMap, String columnPrefix) throws SQLException {
        String columnName;
        Class resultType = resultMap.getType();
        if (!resultMap.getResultMappings().isEmpty()) {
            List resultMappingList = resultMap.getResultMappings();
            ResultMapping mapping = (ResultMapping)resultMappingList.get(0);
            columnName = this.prependPrefix(mapping.getColumn(), columnPrefix);
        } else {
            columnName = rowResultWrapper.getColumnNames().get(0);
        }
        TypeHandler<?> typeHandler = rowResultWrapper.getTypeHandler(resultType, columnName);
        ((TypeHandleContext)this.delegatedTypeHandler).contextWith(typeHandler, rowResultWrapper);
        return this.delegatedTypeHandler.getResult(null, columnName);
    }

    public ResultMap resolveDiscriminatedResultMap(RowResultWrapper rowResultWrapper, ResultMap resultMap, String columnPrefix) throws SQLException {
        Object value;
        String discriminatedMapId;
        HashSet<String> pastDiscriminators = new HashSet<String>();
        Discriminator discriminator = resultMap.getDiscriminator();
        while (discriminator != null && this.r2DbcMybatisConfiguration.hasResultMap(discriminatedMapId = discriminator.getMapIdFor(String.valueOf(value = this.getDiscriminatorValue(rowResultWrapper, discriminator, columnPrefix))))) {
            resultMap = this.r2DbcMybatisConfiguration.getResultMap(discriminatedMapId);
            Discriminator lastDiscriminator = discriminator;
            discriminator = resultMap.getDiscriminator();
            if (discriminator != lastDiscriminator && pastDiscriminators.add(discriminatedMapId)) continue;
            break;
        }
        return resultMap;
    }

    private Object getDiscriminatorValue(RowResultWrapper rowResultWrapper, Discriminator discriminator, String columnPrefix) throws SQLException {
        ResultMapping resultMapping = discriminator.getResultMapping();
        TypeHandler typeHandler = resultMapping.getTypeHandler();
        ((TypeHandleContext)this.delegatedTypeHandler).contextWith(typeHandler, rowResultWrapper);
        return this.delegatedTypeHandler.getResult(null, this.prependPrefix(resultMapping.getColumn(), columnPrefix));
    }

    private void storeObject(ResultHandler<?> resultHandler, DefaultResultContext<Object> resultContext, Object rowValue, ResultMapping parentMapping, RowResultWrapper rowResultWrapper) {
        if (parentMapping != null) {
            this.linkToParents(rowResultWrapper, parentMapping, rowValue);
        } else {
            resultContext.nextResultObject(rowValue);
            resultHandler.handleResult(resultContext);
        }
    }

    private boolean hasTypeHandlerForResultObject(Class<?> resultType) {
        return this.typeHandlerRegistry.hasTypeHandler(resultType);
    }

    private void linkToParents(RowResultWrapper rowResultWrapper, ResultMapping parentMapping, Object rowValue) {
        CacheKey parentKey = this.createKeyForMultipleResults(rowResultWrapper, parentMapping, parentMapping.getColumn(), parentMapping.getForeignColumn());
        List<PendingRelation> parents = this.pendingRelations.get(parentKey);
        if (parents != null) {
            for (PendingRelation parent : parents) {
                if (parent == null || rowValue == null) continue;
                this.linkObjects(parent.metaObject, parent.propertyMapping, rowValue);
            }
        }
    }

    private CacheKey createKeyForMultipleResults(RowResultWrapper rowResultWrapper, ResultMapping resultMapping, String names, String columns) {
        CacheKey cacheKey = new CacheKey();
        cacheKey.update((Object)resultMapping);
        if (columns != null && names != null) {
            String[] columnsArray = columns.split(",");
            String[] namesArray = names.split(",");
            Row row = rowResultWrapper.getRow();
            for (int i = 0; i < columnsArray.length; ++i) {
                Object value = row.get(columnsArray[i]);
                if (value == null) continue;
                cacheKey.update((Object)namesArray[i]);
                cacheKey.update(value);
            }
        }
        return cacheKey;
    }

    private void putAncestor(Object resultObject, String resultMapId) {
        this.ancestorObjects.put(resultMapId, resultObject);
    }

    private boolean shouldApplyAutomaticMappings(ResultMap resultMap, boolean isNested) {
        if (resultMap.getAutoMapping() != null) {
            return resultMap.getAutoMapping();
        }
        if (isNested) {
            return AutoMappingBehavior.FULL == this.r2DbcMybatisConfiguration.getAutoMappingBehavior();
        }
        return AutoMappingBehavior.NONE != this.r2DbcMybatisConfiguration.getAutoMappingBehavior();
    }

    private String prependPrefix(String columnName, String prefix) {
        if (columnName == null || columnName.length() == 0 || prefix == null || prefix.length() == 0) {
            return columnName;
        }
        return prefix + columnName;
    }

    private String getColumnPrefix(String parentPrefix, ResultMapping resultMapping) {
        StringBuilder columnPrefixBuilder = new StringBuilder();
        if (parentPrefix != null) {
            columnPrefixBuilder.append(parentPrefix);
        }
        if (resultMapping.getColumnPrefix() != null) {
            columnPrefixBuilder.append(resultMapping.getColumnPrefix());
        }
        return columnPrefixBuilder.length() == 0 ? null : columnPrefixBuilder.toString().toUpperCase(Locale.ENGLISH);
    }

    private boolean anyNotNullColumnHasValue(ResultMapping resultMapping, String columnPrefix, RowResultWrapper rowResultWrapper) throws SQLException {
        Set notNullColumns = resultMapping.getNotNullColumns();
        if (notNullColumns != null && !notNullColumns.isEmpty()) {
            Row row = rowResultWrapper.getRow();
            for (String column : notNullColumns) {
                if (row.get(this.prependPrefix(column, columnPrefix)) == null) continue;
                return true;
            }
            return false;
        }
        if (columnPrefix != null) {
            for (String columnName : rowResultWrapper.getColumnNames()) {
                if (!columnName.toUpperCase(Locale.ENGLISH).startsWith(columnPrefix.toUpperCase(Locale.ENGLISH))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private ResultMap getNestedResultMap(RowResultWrapper rowResultWrapper, String nestedResultMapId, String columnPrefix) throws SQLException {
        ResultMap nestedResultMap = this.r2DbcMybatisConfiguration.getResultMap(nestedResultMapId);
        return this.resolveDiscriminatedResultMap(rowResultWrapper, nestedResultMap, columnPrefix);
    }

    private CacheKey createRowKey(ResultMap resultMap, RowResultWrapper rowResultWrapper, String columnPrefix) throws SQLException {
        CacheKey cacheKey = new CacheKey();
        cacheKey.update((Object)resultMap.getId());
        List<ResultMapping> resultMappings = this.getResultMappingsForRowKey(resultMap);
        if (resultMappings.isEmpty()) {
            if (Map.class.isAssignableFrom(resultMap.getType())) {
                this.createRowKeyForMap(rowResultWrapper, cacheKey);
            } else {
                this.createRowKeyForUnmappedProperties(resultMap, rowResultWrapper, cacheKey, columnPrefix);
            }
        } else {
            this.createRowKeyForMappedProperties(resultMap, rowResultWrapper, cacheKey, resultMappings, columnPrefix);
        }
        if (cacheKey.getUpdateCount() < 2) {
            return CacheKey.NULL_CACHE_KEY;
        }
        return cacheKey;
    }

    private CacheKey combineKeys(CacheKey rowKey, CacheKey parentRowKey) {
        if (rowKey.getUpdateCount() > 1 && parentRowKey.getUpdateCount() > 1) {
            CacheKey combinedKey;
            try {
                combinedKey = rowKey.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new ExecutorException("Error cloning cache key.  Cause: " + e, (Throwable)e);
            }
            combinedKey.update((Object)parentRowKey);
            return combinedKey;
        }
        return CacheKey.NULL_CACHE_KEY;
    }

    private List<ResultMapping> getResultMappingsForRowKey(ResultMap resultMap) {
        List resultMappings = resultMap.getIdResultMappings();
        if (resultMappings.isEmpty()) {
            resultMappings = resultMap.getPropertyResultMappings();
        }
        return resultMappings;
    }

    private void createRowKeyForMappedProperties(ResultMap resultMap, RowResultWrapper rowResultWrapper, CacheKey cacheKey, List<ResultMapping> resultMappings, String columnPrefix) throws SQLException {
        for (ResultMapping resultMapping : resultMappings) {
            if (!resultMapping.isSimple()) continue;
            String column = this.prependPrefix(resultMapping.getColumn(), columnPrefix);
            TypeHandler typeHandler = resultMapping.getTypeHandler();
            List<String> mappedColumnNames = rowResultWrapper.getMappedColumnNames(resultMap, columnPrefix);
            if (column == null || !mappedColumnNames.contains(column.toUpperCase(Locale.ENGLISH))) continue;
            ((TypeHandleContext)this.delegatedTypeHandler).contextWith(typeHandler, rowResultWrapper);
            Object value = this.delegatedTypeHandler.getResult(null, column);
            if (value == null && !this.r2DbcMybatisConfiguration.isReturnInstanceForEmptyRow()) continue;
            cacheKey.update((Object)column);
            cacheKey.update(value);
        }
    }

    private void createRowKeyForUnmappedProperties(ResultMap resultMap, RowResultWrapper rowResultWrapper, CacheKey cacheKey, String columnPrefix) throws SQLException {
        MetaClass metaType = MetaClass.forClass((Class)resultMap.getType(), (ReflectorFactory)this.reflectorFactory);
        List<String> unmappedColumnNames = rowResultWrapper.getUnmappedColumnNames(resultMap, columnPrefix);
        Iterator<String> iterator = unmappedColumnNames.iterator();
        while (iterator.hasNext()) {
            String value;
            String column;
            String property = column = iterator.next();
            if (columnPrefix != null && !columnPrefix.isEmpty()) {
                if (!column.toUpperCase(Locale.ENGLISH).startsWith(columnPrefix)) continue;
                property = column.substring(columnPrefix.length());
            }
            if (metaType.findProperty(property, this.r2DbcMybatisConfiguration.isMapUnderscoreToCamelCase()) == null || (value = (String)rowResultWrapper.getRow().get(column, String.class)) == null) continue;
            cacheKey.update((Object)column);
            cacheKey.update((Object)value);
        }
    }

    private void createRowKeyForMap(RowResultWrapper rowResultWrapper, CacheKey cacheKey) {
        List<String> columnNames = rowResultWrapper.getColumnNames();
        for (String columnName : columnNames) {
            String value = (String)rowResultWrapper.getRow().get(columnName, String.class);
            if (value == null) continue;
            cacheKey.update((Object)columnName);
            cacheKey.update((Object)value);
        }
    }

    private void linkObjects(MetaObject metaObject, ResultMapping resultMapping, Object rowValue) {
        Object collectionProperty = this.instantiateCollectionPropertyIfAppropriate(resultMapping, metaObject);
        if (collectionProperty != null) {
            MetaObject targetMetaObject = this.r2DbcMybatisConfiguration.newMetaObject(collectionProperty);
            targetMetaObject.add(rowValue);
        } else {
            metaObject.setValue(resultMapping.getProperty(), rowValue);
        }
    }

    private Object instantiateCollectionPropertyIfAppropriate(ResultMapping resultMapping, MetaObject metaObject) {
        block6: {
            String propertyName = resultMapping.getProperty();
            Object propertyValue = metaObject.getValue(propertyName);
            if (propertyValue == null) {
                Class type = resultMapping.getJavaType();
                if (type == null) {
                    type = metaObject.getSetterType(propertyName);
                }
                try {
                    if (this.objectFactory.isCollection(type)) {
                        propertyValue = this.objectFactory.create(type);
                        metaObject.setValue(propertyName, propertyValue);
                        return propertyValue;
                    }
                    break block6;
                }
                catch (Exception e) {
                    throw new ExecutorException("Error instantiating collection property for result '" + resultMapping.getProperty() + "'.  Cause: " + e, (Throwable)e);
                }
            }
            if (this.objectFactory.isCollection(propertyValue.getClass())) {
                return propertyValue;
            }
        }
        return null;
    }

    private TypeHandler initDelegateTypeHandler() {
        return ProxyInstanceFactory.newInstanceOfInterfaces(TypeHandler.class, () -> new DelegateR2dbcResultRowDataHandler(this.r2DbcMybatisConfiguration.getNotSupportedDataTypes(), this.r2DbcMybatisConfiguration.getR2dbcTypeHandlerAdapterRegistry().getR2dbcTypeHandlerAdapters()), TypeHandleContext.class);
    }

    private static class UnMappedColumnAutoMapping {
        private final String column;
        private final String property;
        private final TypeHandler<?> typeHandler;
        private final boolean primitive;

        public UnMappedColumnAutoMapping(String column, String property, TypeHandler<?> typeHandler, boolean primitive) {
            this.column = column;
            this.property = property;
            this.typeHandler = typeHandler;
            this.primitive = primitive;
        }
    }

    private static class PendingRelation {
        public MetaObject metaObject;
        public ResultMapping propertyMapping;

        private PendingRelation() {
        }
    }
}

