/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.defaults;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.r2dbc.spi.ConnectionMetadata;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.util.MapUtil;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.PlaceholderDialect;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.PlaceholderDialectRegistry;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.PlaceholderFormatter;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.support.ReactiveExecutorContextAttribute;

public class DefaultPlaceholderFormatter
implements PlaceholderFormatter {
    private static final Log log = LogFactory.getLog(DefaultPlaceholderFormatter.class);
    private final PlaceholderDialectRegistry placeholderDialectRegistry;
    private final ConcurrentHashMap<Class<? extends PlaceholderDialect>, Cache<String, String>> formattedSqlCache = new ConcurrentHashMap();

    public DefaultPlaceholderFormatter(PlaceholderDialectRegistry placeholderDialectRegistry, Integer sqlCacheMaxSize, Duration sqlCacheExpireDuration) {
        this.placeholderDialectRegistry = placeholderDialectRegistry;
        Set<Class<? extends PlaceholderDialect>> allPlaceholderDialectTypes = placeholderDialectRegistry.getAllPlaceholderDialectTypes();
        for (Class<? extends PlaceholderDialect> placeholderDialectType : allPlaceholderDialectTypes) {
            Cache cache = Caffeine.newBuilder().maximumSize((long)sqlCacheMaxSize.intValue()).expireAfterAccess(sqlCacheExpireDuration).initialCapacity(10).build();
            this.formattedSqlCache.put(placeholderDialectType, (Cache<String, String>)cache);
        }
    }

    @Override
    public String replaceSqlPlaceholder(ConnectionMetadata connectionMetadata, BoundSql boundSql, ReactiveExecutorContextAttribute reactiveExecutorContextAttribute) {
        Optional<PlaceholderDialect> optionalPlaceholderDialect = this.placeholderDialectRegistry.getPlaceholderDialect(connectionMetadata, reactiveExecutorContextAttribute).filter(placeholderDialect -> !Objects.equals(placeholderDialect.getMarker(), "?"));
        String originalSql = boundSql.getSql();
        if (!optionalPlaceholderDialect.isPresent()) {
            if (log.isTraceEnabled()) {
                log.trace("Placeholder dialect not found or is default placeholder ,use original sql");
            }
            return originalSql;
        }
        PlaceholderDialect placeholderDialect2 = optionalPlaceholderDialect.get();
        Cache<String, String> cache = this.formattedSqlCache.get(placeholderDialect2.getClass());
        if (Objects.isNull(cache)) {
            throw new IllegalStateException("Placeholder dialect found,but Placeholder dialect sql cache is null,Placeholder dialect type : " + placeholderDialect2.getClass());
        }
        return (String)MapUtil.computeIfAbsent((Map)cache.asMap(), (Object)originalSql, statementId -> this.formatPlaceholderInternal(placeholderDialect2, boundSql));
    }

    protected String formatPlaceholderInternal(PlaceholderDialect placeholderDialect, BoundSql boundSql) {
        String sql = boundSql.getSql();
        char defaultPlaceholder = "?".charAt(0);
        boolean containsAnyPlaceholder = sql.chars().anyMatch(aChar -> aChar == defaultPlaceholder);
        if (!containsAnyPlaceholder) {
            if (log.isTraceEnabled()) {
                log.trace("Placeholder not found ,use original sql");
            }
            return sql;
        }
        char[] chars = sql.toCharArray();
        String marker = placeholderDialect.getMarker();
        StringBuilder builder = new StringBuilder(sql.length() + 10);
        if (placeholderDialect.usingIndexMarker()) {
            int startIndex = placeholderDialect.startIndex();
            for (int i = 0; i < chars.length; ++i) {
                boolean forwardMatched;
                char aChar2 = chars[i];
                if (aChar2 != defaultPlaceholder) {
                    builder.append(aChar2);
                    continue;
                }
                boolean previousMatched = chars[i - 1] == defaultPlaceholder;
                boolean bl = forwardMatched = i + 1 < chars.length && chars[i + 1] == defaultPlaceholder;
                if (previousMatched || forwardMatched) {
                    builder.append(aChar2);
                    continue;
                }
                builder.append(marker).append(startIndex);
                ++startIndex;
            }
            String formattedSql = builder.toString();
            if (log.isDebugEnabled()) {
                log.debug("Format placeholder based by index, with (" + placeholderDialect.getClass().getSimpleName() + ")");
                log.debug("Formatted SQL  => " + formattedSql);
            }
            return formattedSql;
        }
        List parameterMappings = boundSql.getParameterMappings();
        int identifierCount = 0;
        for (int i = 0; i < chars.length; ++i) {
            boolean forwardMatched;
            char aChar3 = chars[i];
            if (aChar3 != defaultPlaceholder) {
                builder.append(aChar3);
                continue;
            }
            boolean previousMatched = chars[i - 1] == defaultPlaceholder;
            boolean bl = forwardMatched = i + 1 < chars.length && chars[i + 1] == defaultPlaceholder;
            if (previousMatched || forwardMatched) {
                builder.append(aChar3);
                continue;
            }
            builder.append(marker);
            String parameterProperty = ((ParameterMapping)parameterMappings.get(identifierCount)).getProperty().replaceAll("\\.", "_");
            builder.append(parameterProperty);
            ++identifierCount;
        }
        String formattedSql = builder.toString();
        if (log.isDebugEnabled()) {
            log.debug("Format placeholder based on parameter name, with (" + placeholderDialect.getClass().getSimpleName() + ")");
            log.debug("Formatted SQL  => " + formattedSql);
        }
        return formattedSql;
    }
}

