/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.defaults;

import io.r2dbc.spi.ConnectionMetadata;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.PlaceholderDialect;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.PlaceholderDialectRegistry;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.dialect.H2PlaceholderDialect;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.dialect.MariaDBPlaceholderDialect;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.dialect.MySQLPlaceholderDialect;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.dialect.OraclePlaceholderDialect;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.dialect.PostgreSQLPlaceholderDialect;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.dialect.SQLServerPlaceholderDialect;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.support.ReactiveExecutorContextAttribute;

public class DefaultPlaceholderDialectRegistry
implements PlaceholderDialectRegistry {
    private final Map<String, PlaceholderDialect> placeholderDialects = new HashMap<String, PlaceholderDialect>();

    public DefaultPlaceholderDialectRegistry() {
        this.register(new MySQLPlaceholderDialect());
        this.register(new MariaDBPlaceholderDialect());
        this.register(new PostgreSQLPlaceholderDialect());
        this.register(new H2PlaceholderDialect());
        this.register(new OraclePlaceholderDialect());
        this.register(new SQLServerPlaceholderDialect());
    }

    @Override
    public void register(PlaceholderDialect placeholderDialect) {
        this.placeholderDialects.put(placeholderDialect.name().toLowerCase(Locale.ENGLISH), placeholderDialect);
    }

    @Override
    public Set<Class<? extends PlaceholderDialect>> getAllPlaceholderDialectTypes() {
        return this.placeholderDialects.values().stream().map(Object::getClass).collect(Collectors.toSet());
    }

    @Override
    public Optional<PlaceholderDialect> getPlaceholderDialect(ConnectionMetadata connectionMetadata, ReactiveExecutorContextAttribute reactiveExecutorContextAttribute) {
        String name = Optional.ofNullable(reactiveExecutorContextAttribute.getAttribute().get("PLACEHOLDER_DIALECT_NAME_ATTRIBUTE_KEY")).filter(value -> value instanceof String).map(String.class::cast).orElseGet(() -> ((ConnectionMetadata)connectionMetadata).getDatabaseProductName());
        String lowerCaseName = name.toLowerCase(Locale.ENGLISH);
        if (this.placeholderDialects.containsKey(lowerCaseName)) {
            return Optional.of(this.placeholderDialects.get(lowerCaseName));
        }
        return this.placeholderDialects.values().stream().filter(placeholderDialect -> placeholderDialect.supported(connectionMetadata, reactiveExecutorContextAttribute)).findFirst();
    }
}

