/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.delegate;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.session.Configuration;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.ReactiveSqlSession;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.binding.MapperProxyFactory;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.builder.R2dbcMapperAnnotationBuilder;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.delegate.R2dbcMybatisConfiguration;

public class R2dbcMapperRegistry
extends MapperRegistry {
    private final Map<Class<?>, MapperProxyFactory<?>> knownMappers = new HashMap();
    private final R2dbcMybatisConfiguration configuration;

    public R2dbcMapperRegistry(R2dbcMybatisConfiguration r2dbcMybatisConfiguration) {
        super((Configuration)r2dbcMybatisConfiguration);
        this.configuration = r2dbcMybatisConfiguration;
    }

    public <T> T getMapper(Class<T> type, ReactiveSqlSession reactiveSqlSession) {
        MapperProxyFactory<?> mapperProxyFactory = this.knownMappers.get(type);
        if (mapperProxyFactory == null) {
            throw new BindingException("Type " + type + " is not known to the MapperRegistry.");
        }
        try {
            return (T)mapperProxyFactory.newInstance(reactiveSqlSession);
        }
        catch (Exception e) {
            throw new BindingException("Error getting mapper instance. Cause: " + e, (Throwable)e);
        }
    }

    public <T> boolean hasMapper(Class<T> type) {
        return this.knownMappers.containsKey(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addMapper(Class<T> type) {
        if (type.isInterface()) {
            if (this.hasMapper(type)) {
                throw new BindingException("Type " + type + " is already known to the MapperRegistry.");
            }
            boolean loadCompleted = false;
            try {
                this.knownMappers.put(type, new MapperProxyFactory<T>(type));
                R2dbcMapperAnnotationBuilder parser = new R2dbcMapperAnnotationBuilder(this.configuration, type);
                parser.parse();
                loadCompleted = true;
            }
            finally {
                if (!loadCompleted) {
                    this.knownMappers.remove(type);
                }
            }
        }
    }

    public Collection<Class<?>> getMappers() {
        return Collections.unmodifiableCollection(this.knownMappers.keySet());
    }
}

