/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.defaults;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.r2dbc.spi.ConnectionFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.util.MapUtil;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.PlaceholderDialect;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.PlaceholderDialectRegistry;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.PlaceholderFormatter;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.support.ReactiveExecutorContextAttribute;

public class DefaultPlaceholderFormatter
implements PlaceholderFormatter {
    private static final Log log = LogFactory.getLog(DefaultPlaceholderFormatter.class);
    private final Pattern jdbcPlaceholderPattern = Pattern.compile("\\?");
    private final PlaceholderDialectRegistry placeholderDialectRegistry;
    private final ConcurrentHashMap<Class<? extends PlaceholderDialect>, Cache<String, String>> formattedSqlCache = new ConcurrentHashMap();

    public DefaultPlaceholderFormatter(PlaceholderDialectRegistry placeholderDialectRegistry, Integer sqlCacheMaxSize, Duration sqlCacheExpireDuration) {
        this.placeholderDialectRegistry = placeholderDialectRegistry;
        Set<Class<? extends PlaceholderDialect>> allPlaceholderDialectTypes = placeholderDialectRegistry.getAllPlaceholderDialectTypes();
        for (Class<? extends PlaceholderDialect> placeholderDialectType : allPlaceholderDialectTypes) {
            Cache cache = Caffeine.newBuilder().maximumSize((long)sqlCacheMaxSize.intValue()).expireAfterAccess(sqlCacheExpireDuration).initialCapacity(10).build();
            this.formattedSqlCache.put(placeholderDialectType, (Cache<String, String>)cache);
        }
    }

    @Override
    public String replaceSqlPlaceholder(ConnectionFactory connectionFactory, BoundSql boundSql, ReactiveExecutorContextAttribute reactiveExecutorContextAttribute) {
        Optional<PlaceholderDialect> optionalPlaceholderDialect = this.placeholderDialectRegistry.getPlaceholderDialect(connectionFactory, reactiveExecutorContextAttribute).filter(placeholderDialect -> !Objects.equals(placeholderDialect.getMarker(), "?"));
        String originalSql = boundSql.getSql();
        if (!optionalPlaceholderDialect.isPresent()) {
            if (log.isTraceEnabled()) {
                log.trace("Placeholder dialect not found ,use original sql");
            }
            return originalSql;
        }
        PlaceholderDialect placeholderDialect2 = optionalPlaceholderDialect.get();
        Cache<String, String> cache = this.formattedSqlCache.get(placeholderDialect2.getClass());
        if (Objects.isNull(cache)) {
            throw new IllegalStateException("Placeholder dialect is found,but Placeholder dialect sql cache is null,Placeholder dialect type : " + placeholderDialect2.getClass());
        }
        return (String)MapUtil.computeIfAbsent((Map)cache.asMap(), (Object)originalSql, statementId -> this.formatPlaceholderInternal(placeholderDialect2, boundSql));
    }

    protected String formatPlaceholderInternal(PlaceholderDialect placeholderDialect, BoundSql boundSql) {
        String sql = boundSql.getSql();
        List<Integer> placeholderIndexList = this.extractJdbcPlaceholderIndex(sql);
        if (placeholderIndexList.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("Placeholder index not found ,use original sql");
            }
            return sql;
        }
        String marker = placeholderDialect.getMarker();
        int startIndex = placeholderDialect.startIndex();
        StringBuilder builder = new StringBuilder();
        if (placeholderDialect.usingIndexMarker()) {
            for (int i = 0; i < placeholderIndexList.size(); ++i) {
                Integer placeholderIndexValue = placeholderIndexList.get(i);
                builder.append(sql, i == 0 ? 0 : placeholderIndexList.get(i - 1) + 1, (int)placeholderIndexValue).append(marker).append(i + startIndex);
            }
            if (placeholderIndexList.get(placeholderIndexList.size() - 1) < sql.length()) {
                builder.append(sql, placeholderIndexList.get(placeholderIndexList.size() - 1) + 1, sql.length());
            }
            String formattedSql = builder.toString();
            if (log.isDebugEnabled()) {
                log.debug("Format placeholder based by index, with (" + placeholderDialect.getClass().getSimpleName() + ") => " + formattedSql);
            }
            return formattedSql;
        }
        List parameterMappings = boundSql.getParameterMappings();
        for (int i = 0; i < placeholderIndexList.size(); ++i) {
            Integer placeholderIndexValue = placeholderIndexList.get(i);
            builder.append(sql, i == 0 ? 0 : placeholderIndexList.get(i - 1) + 1, (int)placeholderIndexValue).append(marker);
            String parameterProperty = ((ParameterMapping)parameterMappings.get(i)).getProperty().replaceAll("\\.", "_");
            builder.append(parameterProperty);
        }
        if (placeholderIndexList.get(placeholderIndexList.size() - 1) < sql.length()) {
            builder.append(sql, placeholderIndexList.get(placeholderIndexList.size() - 1) + 1, sql.length());
        }
        String formattedSql = builder.toString();
        if (log.isDebugEnabled()) {
            log.debug("Format placeholder based on parameter name, with (" + placeholderDialect.getClass().getSimpleName() + ") \n => " + formattedSql);
        }
        return formattedSql;
    }

    protected List<Integer> extractJdbcPlaceholderIndex(String sql) {
        Matcher matcher = this.jdbcPlaceholderPattern.matcher(sql);
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int previous = -1;
        int result = -1;
        while (matcher.find()) {
            int start = matcher.start();
            if (previous < 0) {
                previous = start;
                result = start;
                continue;
            }
            if (start - previous == 1) {
                previous = start;
                if (result < 0) continue;
                result = -1;
                continue;
            }
            if (result >= 0) {
                indexList.add(result);
            }
            previous = start;
            result = start;
        }
        if (result > 0) {
            indexList.add(result);
        }
        return indexList;
    }
}

