/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.parameter;

import io.r2dbc.spi.Statement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.delegate.R2dbcMybatisConfiguration;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.parameter.ParameterHandlerContext;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.support.R2dbcStatementLog;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.type.R2dbcTypeHandlerAdapter;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.support.ProxyInstanceFactory;

public class DelegateR2dbcParameterHandler
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(DelegateR2dbcParameterHandler.class);
    private final R2dbcMybatisConfiguration configuration;
    private final ParameterHandler parameterHandler;
    private final Map<Class<?>, Field> parameterHandlerFieldMap;
    private final Statement delegateStatement;
    private final PreparedStatement delegatedPreparedStatement;
    private final AtomicReference<ParameterHandlerContext> parameterHandlerContextReference = new AtomicReference();
    private final R2dbcStatementLog r2dbcStatementLog;

    public DelegateR2dbcParameterHandler(R2dbcMybatisConfiguration r2DbcMybatisConfiguration, ParameterHandler parameterHandler, Statement statement, R2dbcStatementLog r2dbcStatementLog) {
        this.configuration = r2DbcMybatisConfiguration;
        this.parameterHandler = parameterHandler;
        this.delegateStatement = statement;
        this.r2dbcStatementLog = r2dbcStatementLog;
        this.delegatedPreparedStatement = this.initDelegatedPreparedStatement();
        this.parameterHandlerFieldMap = Stream.of(parameterHandler.getClass().getDeclaredFields()).collect(Collectors.toMap(Field::getType, field -> {
            field.setAccessible(true);
            return field;
        }));
    }

    private PreparedStatement initDelegatedPreparedStatement() {
        return ProxyInstanceFactory.newInstanceOfInterfaces(PreparedStatement.class, () -> new DelegateR2dbcStatement(this.delegateStatement, this.configuration.getR2dbcTypeHandlerAdapterRegistry().getR2dbcTypeHandlerAdapters(), this.configuration.getNotSupportedDataTypes()), new Class[0]);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (!Objects.equals("setParameters", methodName)) {
            return method.invoke((Object)this.parameterHandler, args);
        }
        this.setParameters(this.delegatedPreparedStatement);
        return null;
    }

    private <T> T getField(ParameterHandler parameterHandler, Class<T> fieldType) {
        Field field = this.parameterHandlerFieldMap.get(fieldType);
        try {
            return (T)field.get(parameterHandler);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public void setParameters(PreparedStatement ps) {
        BoundSql boundSql = this.getField(this.parameterHandler, BoundSql.class);
        TypeHandlerRegistry typeHandlerRegistry = this.getField(this.parameterHandler, TypeHandlerRegistry.class);
        Object parameterObject = this.parameterHandler.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        ParameterHandlerContext parameterHandlerContext = new ParameterHandlerContext();
        this.parameterHandlerContextReference.getAndSet(parameterHandlerContext);
        ArrayList<Object> columnValues = new ArrayList<Object>();
        if (parameterMappings != null) {
            for (int i = 0; i < parameterMappings.size(); ++i) {
                Object value;
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                if (boundSql.hasAdditionalParameter(propertyName)) {
                    value = boundSql.getAdditionalParameter(propertyName);
                } else if (parameterObject == null) {
                    value = null;
                } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    value = parameterObject;
                } else {
                    MetaObject metaObject = this.configuration.newMetaObject(parameterObject);
                    value = metaObject.getValue(propertyName);
                }
                TypeHandler typeHandler = parameterMapping.getTypeHandler();
                JdbcType jdbcType = parameterMapping.getJdbcType();
                if (value == null && jdbcType == null) {
                    jdbcType = this.configuration.getJdbcTypeForNull();
                }
                try {
                    if (value == null && jdbcType != null) {
                        this.delegateStatement.bindNull(i, parameterMapping.getJavaType());
                        columnValues.add(null);
                        continue;
                    }
                    parameterHandlerContext.setIndex(i);
                    parameterHandlerContext.setJavaType(parameterMapping.getJavaType());
                    parameterHandlerContext.setJdbcType(jdbcType);
                    typeHandler.setParameter(ps, i, value, jdbcType);
                    columnValues.add(value);
                    continue;
                }
                catch (SQLException | TypeException e) {
                    throw new TypeException("Could not set parameters for mapping: " + parameterMapping + ". Cause: " + e, e);
                }
            }
        }
        this.r2dbcStatementLog.logParameters(columnValues);
    }

    private class DelegateR2dbcStatement
    implements InvocationHandler {
        private final Statement statement;
        private final Map<Class<?>, R2dbcTypeHandlerAdapter> r2dbcTypeHandlerAdapters;
        private final Set<Class<?>> notSupportedDataTypes;

        DelegateR2dbcStatement(Statement statement, Map<Class<?>, R2dbcTypeHandlerAdapter> r2dbcTypeHandlerAdapters, Set<Class<?>> notSupportedDataTypes) {
            this.statement = statement;
            this.r2dbcTypeHandlerAdapters = r2dbcTypeHandlerAdapters;
            this.notSupportedDataTypes = notSupportedDataTypes;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("equals") || methodName.equals("hashCode") || methodName.equals("toString")) {
                return method.invoke(proxy, args);
            }
            if (!methodName.startsWith("set")) {
                return null;
            }
            int index = (Integer)args[0];
            Object parameter = args[1];
            Class<?> parameterClass = parameter.getClass();
            if (this.notSupportedDataTypes.contains(parameterClass)) {
                throw new IllegalArgumentException("Unsupported Parameter type : " + parameterClass);
            }
            if (this.r2dbcTypeHandlerAdapters.containsKey(parameterClass)) {
                log.debug("Found r2dbc type handler adapter for type : " + parameterClass);
                R2dbcTypeHandlerAdapter r2dbcTypeHandlerAdapter = this.r2dbcTypeHandlerAdapters.get(parameterClass);
                ParameterHandlerContext parameterHandlerContext = (ParameterHandlerContext)DelegateR2dbcParameterHandler.this.parameterHandlerContextReference.get();
                r2dbcTypeHandlerAdapter.setParameter(this.statement, parameterHandlerContext, parameter);
                return null;
            }
            this.statement.bind(index, parameter);
            return null;
        }
    }
}

