/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.connection;

import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.r2dbc.spi.Wrapped;
import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.reactivestreams.Publisher;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.MybatisReactiveContextManager;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.support.ReactiveExecutorContext;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.support.ProxyInstanceFactory;
import reactor.core.publisher.Mono;

public class DefaultTransactionSupportConnectionFactory
implements ConnectionFactory,
Wrapped<ConnectionFactory>,
Closeable {
    private static final Log log = LogFactory.getLog(DefaultTransactionSupportConnectionFactory.class);
    private final ConnectionFactory targetConnectionFactory;

    public DefaultTransactionSupportConnectionFactory(ConnectionFactory targetConnectionFactory) {
        this.targetConnectionFactory = targetConnectionFactory;
    }

    public Mono<? extends Connection> create() {
        return this.getOptionalTransactionAwareConnectionProxy(this.targetConnectionFactory);
    }

    public ConnectionFactoryMetadata getMetadata() {
        return this.targetConnectionFactory.getMetadata();
    }

    public ConnectionFactory unwrap() {
        return this.targetConnectionFactory;
    }

    @Override
    public void close() {
        ConnectionPool connectionPool;
        if (this.targetConnectionFactory instanceof ConnectionPool && !(connectionPool = (ConnectionPool)this.targetConnectionFactory).isDisposed()) {
            connectionPool.dispose();
        }
    }

    private Mono<Connection> getOptionalTransactionAwareConnectionProxy(ConnectionFactory targetConnectionFactory) {
        return MybatisReactiveContextManager.currentContext().flatMap(reactiveExecutorContext -> Mono.justOrEmpty(reactiveExecutorContext.getConnection()).switchIfEmpty(Mono.from((Publisher)targetConnectionFactory.create()).map(newConnection -> {
            log.debug("[Get connection]Old connection not exist ,Create connection : " + newConnection);
            return this.createConnectionProxy((Connection)newConnection, reactiveExecutorContext.isWithTransaction());
        })).doOnNext(transactionConnection -> {
            log.debug("[Get connection]Bind to context : " + transactionConnection);
            reactiveExecutorContext.bindConnection((Connection)transactionConnection);
        }).flatMap(newConnection -> Mono.justOrEmpty((Object)reactiveExecutorContext.getIsolationLevel()).flatMap(isolationLevel -> {
            log.debug("[Get connection]Transaction isolation level exist : " + isolationLevel);
            return Mono.from((Publisher)newConnection.setTransactionIsolationLevel(isolationLevel)).then(Mono.defer(() -> {
                log.debug("[Get connection]Force set autocommit to false");
                return Mono.from((Publisher)newConnection.setAutoCommit(reactiveExecutorContext.isAutoCommit()));
            }));
        }).switchIfEmpty(Mono.from((Publisher)newConnection.setAutoCommit(reactiveExecutorContext.isAutoCommit()))).then(Mono.defer(() -> {
            if (reactiveExecutorContext.setActiveTransaction()) {
                return Mono.from((Publisher)newConnection.beginTransaction()).then(Mono.defer(() -> Mono.just((Object)newConnection)));
            }
            return Mono.just((Object)newConnection);
        }))));
    }

    private Connection createConnectionProxy(Connection connection, boolean suspendClose) {
        return ProxyInstanceFactory.newInstanceOfInterfaces(Connection.class, () -> new TransactionAwareConnection(connection, suspendClose), Wrapped.class);
    }

    private static class TransactionAwareConnection
    implements InvocationHandler {
        private final Connection connection;
        private final boolean suspendClose;
        private boolean closed = false;

        TransactionAwareConnection(Connection connection, boolean suspendClose) {
            this.connection = connection;
            this.suspendClose = suspendClose;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "toString": {
                    return this.proxyToString(proxy);
                }
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "unwrap": {
                    return this.connection;
                }
                case "close": {
                    if (this.closed) {
                        return Mono.empty();
                    }
                    return MybatisReactiveContextManager.currentContext().flatMap(reactiveExecutorContext -> {
                        if (reactiveExecutorContext.isForceRollback()) {
                            return this.handleRollback((ReactiveExecutorContext)reactiveExecutorContext);
                        }
                        if (reactiveExecutorContext.isForceCommit()) {
                            return this.handleCommit((ReactiveExecutorContext)reactiveExecutorContext);
                        }
                        if (reactiveExecutorContext.isRequireClosed()) {
                            log.debug("[Close connection]close connection");
                            return this.executeCloseConnection((ReactiveExecutorContext)reactiveExecutorContext);
                        }
                        if (!this.suspendClose) {
                            return this.executeCloseConnection((ReactiveExecutorContext)reactiveExecutorContext);
                        }
                        log.trace("[Close connection]neither rollback or commit,nothing to do");
                        return Mono.empty();
                    });
                }
                case "isClosed": {
                    return this.closed;
                }
            }
            if (this.closed) {
                throw new IllegalStateException("Connection handle already closed");
            }
            try {
                return method.invoke((Object)this.connection, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        private Mono<Void> handleRollback(ReactiveExecutorContext reactiveExecutorContext) {
            return Mono.just((Object)reactiveExecutorContext.isRequireClosed()).filter(requireClose -> requireClose).flatMap(requireClose -> {
                log.debug("[Close connection]rollback and close connection");
                return Mono.from((Publisher)this.connection.rollbackTransaction()).then(Mono.defer(() -> {
                    reactiveExecutorContext.setForceRollback(false);
                    return this.executeCloseConnection(reactiveExecutorContext);
                }));
            }).switchIfEmpty(Mono.defer(() -> {
                log.debug("[Close connection]just rollback,not close connection");
                reactiveExecutorContext.setForceRollback(false);
                return Mono.from((Publisher)this.connection.rollbackTransaction()).onErrorResume(Exception.class, this::onErrorOperation);
            }));
        }

        private Mono<Void> handleCommit(ReactiveExecutorContext reactiveExecutorContext) {
            return Mono.just((Object)reactiveExecutorContext.isRequireClosed()).filter(requireClose -> requireClose).flatMap(requireClose -> {
                log.debug("[Close connection]commit and close connection");
                return Mono.from((Publisher)this.connection.commitTransaction()).then(Mono.defer(() -> {
                    reactiveExecutorContext.setForceCommit(false);
                    return this.executeCloseConnection(reactiveExecutorContext);
                }));
            }).switchIfEmpty(Mono.defer(() -> {
                log.debug("[Close connection]just commit,not close connection");
                reactiveExecutorContext.setForceCommit(false);
                return Mono.from((Publisher)this.connection.commitTransaction()).onErrorResume(Exception.class, this::onErrorOperation);
            }));
        }

        private Mono<Void> executeCloseConnection(ReactiveExecutorContext reactiveExecutorContext) {
            log.debug("[Close Connection]Connection : " + this.connection);
            return Mono.from((Publisher)this.connection.close()).doOnSubscribe(s -> {
                this.closed = true;
            }).then(Mono.defer(() -> Mono.justOrEmpty(reactiveExecutorContext.clearConnection()).flatMap(oldConnection -> {
                log.debug("[Close Connection]Clear connection in context : " + oldConnection);
                return Mono.empty();
            }))).then().onErrorResume(Exception.class, this::onErrorOperation);
        }

        private Mono<Void> onErrorOperation(Exception e) {
            return Mono.from((Publisher)this.connection.close()).doOnSubscribe(v -> {
                this.closed = true;
            }).then(Mono.error((Throwable)e));
        }

        private String proxyToString(Object proxy) {
            return "Transaction-support proxy for target Connection [" + this.connection.toString() + "],Original Proxy [" + proxy + "]";
        }
    }
}

