/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.key;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.RowBounds;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.delegate.R2dbcMybatisConfiguration;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.ReactiveMybatisExecutor;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.key.KeyGeneratorType;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.key.R2dbcKeyGenerator;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.result.RowResultWrapper;
import reactor.core.publisher.Mono;

public class SelectR2dbcKeyGenerator
implements R2dbcKeyGenerator {
    private final boolean executeBefore;
    private final MappedStatement keyStatement;
    private final R2dbcMybatisConfiguration r2dbcMybatisConfiguration;
    private final ReactiveMybatisExecutor reactiveMybatisExecutor;

    public SelectR2dbcKeyGenerator(SelectKeyGenerator selectKeyGenerator, R2dbcMybatisConfiguration r2dbcMybatisConfiguration, ReactiveMybatisExecutor reactiveMybatisExecutor) {
        this.executeBefore = SelectKeyGeneratorFieldContainer.getOriginalExecuteBefore(selectKeyGenerator);
        this.keyStatement = SelectKeyGeneratorFieldContainer.getOriginalKeyStatement(selectKeyGenerator);
        this.r2dbcMybatisConfiguration = r2dbcMybatisConfiguration;
        this.reactiveMybatisExecutor = reactiveMybatisExecutor;
    }

    @Override
    public KeyGeneratorType keyGeneratorType() {
        return this.executeBefore ? KeyGeneratorType.SELECT_KEY_BEFORE : KeyGeneratorType.SELECT_KEY_AFTER;
    }

    @Override
    public Mono<Boolean> processSelectKey(KeyGeneratorType keyGeneratorType, MappedStatement ms, Object parameter) {
        if (!this.keyGeneratorType().equals((Object)keyGeneratorType)) {
            return Mono.just((Object)false);
        }
        try {
            if (parameter != null && this.keyStatement != null && this.keyStatement.getKeyProperties() != null) {
                String[] keyProperties = this.keyStatement.getKeyProperties();
                MetaObject metaParam = this.r2dbcMybatisConfiguration.newMetaObject(parameter);
                return this.reactiveMybatisExecutor.query(this.keyStatement, parameter, RowBounds.DEFAULT).collectList().flatMap(values -> {
                    if (values.isEmpty()) {
                        return Mono.error((Throwable)new ExecutorException("SelectKey returned no data."));
                    }
                    if (values.size() > 1) {
                        return Mono.error((Throwable)new ExecutorException("SelectKey returned more than one value."));
                    }
                    MetaObject metaResult = this.r2dbcMybatisConfiguration.newMetaObject(values.get(0));
                    if (keyProperties.length == 1) {
                        if (metaResult.hasGetter(keyProperties[0])) {
                            this.setValue(metaParam, keyProperties[0], metaResult.getValue(keyProperties[0]));
                        } else {
                            this.setValue(metaParam, keyProperties[0], values.get(0));
                        }
                    } else {
                        this.handleMultipleProperties(keyProperties, metaParam, metaResult);
                    }
                    return Mono.just((Object)true);
                });
            }
        }
        catch (Exception e) {
            return Mono.error((Throwable)new ExecutorException("Error selecting key or setting result to parameter object. Cause: " + e, (Throwable)e));
        }
        return Mono.just((Object)false);
    }

    @Override
    public Integer processGeneratedKeyResult(RowResultWrapper rowResultWrapper, Object parameter) {
        return 0;
    }

    private void handleMultipleProperties(String[] keyProperties, MetaObject metaParam, MetaObject metaResult) {
        String[] keyColumns = this.keyStatement.getKeyColumns();
        if (keyColumns == null || keyColumns.length == 0) {
            for (String keyProperty : keyProperties) {
                this.setValue(metaParam, keyProperty, metaResult.getValue(keyProperty));
            }
        } else {
            if (keyColumns.length != keyProperties.length) {
                throw new ExecutorException("If SelectKey has key columns, the number must match the number of key properties.");
            }
            for (int i = 0; i < keyProperties.length; ++i) {
                this.setValue(metaParam, keyProperties[i], metaResult.getValue(keyColumns[i]));
            }
        }
    }

    private void setValue(MetaObject metaParam, String property, Object value) {
        if (!metaParam.hasSetter(property)) {
            throw new ExecutorException("No setter found for the keyProperty '" + property + "' in " + metaParam.getOriginalObject().getClass().getName() + ".");
        }
        metaParam.setValue(property, value);
    }

    private static class SelectKeyGeneratorFieldContainer {
        private static final Field executeBeforeField;
        private static final Field keyStatementField;

        private SelectKeyGeneratorFieldContainer() {
        }

        public static boolean getOriginalExecuteBefore(SelectKeyGenerator selectKeyGenerator) {
            try {
                return (Boolean)executeBeforeField.get(selectKeyGenerator);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public static MappedStatement getOriginalKeyStatement(SelectKeyGenerator selectKeyGenerator) {
            try {
                return (MappedStatement)keyStatementField.get(selectKeyGenerator);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            Field[] declaredFields = SelectKeyGenerator.class.getDeclaredFields();
            Field originalExecuteBeforeField = null;
            Field originalKeyStatementField = null;
            int reduceCount = 0;
            try {
                for (Field declaredField : declaredFields) {
                    if (reduceCount <= 2) {
                        declaredField.setAccessible(true);
                        Type genericType = declaredField.getGenericType();
                        if ("boolean".equals(genericType.toString())) {
                            originalExecuteBeforeField = declaredField;
                            ++reduceCount;
                            continue;
                        }
                        if (!declaredField.getType().isAssignableFrom(MappedStatement.class)) continue;
                        originalKeyStatementField = declaredField;
                        ++reduceCount;
                        continue;
                    }
                    break;
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            executeBeforeField = originalExecuteBeforeField;
            keyStatementField = originalKeyStatementField;
        }
    }
}

