/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.support;

import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.reflection.ArrayUtil;

public class R2dbcStatementLog {
    private final Log statementLog;

    public R2dbcStatementLog(Log statementLog) {
        this.statementLog = statementLog;
    }

    public void logSql(String sql) {
        if (this.statementLog.isDebugEnabled()) {
            this.debug(" Preparing: " + this.removeExtraWhitespace(sql), true);
        }
    }

    public void logParameters(List<Object> columnValues) {
        this.debug("Parameters: " + this.getParameterValueString(columnValues), true);
    }

    public void logUpdates(Integer updateCount) {
        this.debug("   Updates: " + updateCount, false);
    }

    public void logTotal(Integer rows) {
        this.debug("     Total: " + rows, false);
    }

    private String getParameterValueString(List<Object> columnValues) {
        ArrayList<String> typeList = new ArrayList<String>(columnValues.size());
        for (Object value : columnValues) {
            if (value == null) {
                typeList.add("null");
                continue;
            }
            typeList.add(this.objectValueString(value) + "(" + value.getClass().getSimpleName() + ")");
        }
        String parameters = ((Object)typeList).toString();
        return parameters.substring(1, parameters.length() - 1);
    }

    private String objectValueString(Object value) {
        if (value instanceof Array) {
            try {
                return ArrayUtil.toString((Object)((Array)value).getArray());
            }
            catch (SQLException e) {
                return value.toString();
            }
        }
        return value.toString();
    }

    private String removeExtraWhitespace(String original) {
        return SqlSourceBuilder.removeExtraWhitespaces((String)original);
    }

    private void debug(String text, boolean input) {
        if (this.statementLog.isDebugEnabled()) {
            this.statementLog.debug(this.prefix(input) + text);
        }
    }

    private void trace(String text, boolean input) {
        if (this.statementLog.isTraceEnabled()) {
            this.statementLog.trace(this.prefix(input) + text);
        }
    }

    private String prefix(boolean isInput) {
        char[] buffer = new char[4];
        Arrays.fill(buffer, '=');
        buffer[3] = 32;
        if (isInput) {
            buffer[2] = 62;
        } else {
            buffer[0] = 60;
        }
        return new String(buffer);
    }
}

