/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.defaults;

import io.r2dbc.spi.ConnectionFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.util.MapUtil;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.PlaceholderDialect;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.PlaceholderDialectRegistry;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.placeholder.PlaceholderFormatter;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.support.ReactiveExecutorContextAttribute;

public class DefaultPlaceholderFormatter
implements PlaceholderFormatter {
    private static final Log log = LogFactory.getLog(DefaultPlaceholderFormatter.class);
    private final Pattern jdbcPlaceholderPattern = Pattern.compile("\\?");
    private final PlaceholderDialectRegistry placeholderDialectRegistry;
    private final Map<String, String> formattedSqlCache = new ConcurrentHashMap<String, String>();

    public DefaultPlaceholderFormatter(PlaceholderDialectRegistry placeholderDialectRegistry) {
        this.placeholderDialectRegistry = placeholderDialectRegistry;
    }

    @Override
    public String replaceSqlPlaceholder(ConnectionFactory connectionFactory, BoundSql boundSql, ReactiveExecutorContextAttribute reactiveExecutorContextAttribute) {
        Optional<PlaceholderDialect> optionalPlaceholderDialect = this.placeholderDialectRegistry.getPlaceholderDialect(connectionFactory, reactiveExecutorContextAttribute).filter(placeholderDialect -> !Objects.equals(placeholderDialect.getMarker(), "?"));
        String originalSql = boundSql.getSql();
        if (!optionalPlaceholderDialect.isPresent()) {
            if (log.isTraceEnabled()) {
                log.trace("Placeholder dialect not found ,use original sql");
            }
            return originalSql;
        }
        return (String)MapUtil.computeIfAbsent(this.formattedSqlCache, (Object)originalSql, statementId -> this.formatPlaceholderInternal((PlaceholderDialect)optionalPlaceholderDialect.get(), boundSql));
    }

    private String formatPlaceholderInternal(PlaceholderDialect placeholderDialect, BoundSql boundSql) {
        String sql = boundSql.getSql();
        List<Integer> placeholderIndexList = this.extractJdbcPlaceholderIndex(sql);
        if (placeholderIndexList.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("Placeholder index not found ,use original sql");
            }
            return sql;
        }
        String marker = placeholderDialect.getMarker();
        int startIndex = placeholderDialect.startIndex();
        StringBuilder builder = new StringBuilder();
        if (placeholderDialect.usingIndexMarker()) {
            for (int i = 0; i < placeholderIndexList.size(); ++i) {
                Integer placeholderIndexValue = placeholderIndexList.get(i);
                builder.append(sql, i == 0 ? 0 : placeholderIndexList.get(i - 1) + 1, (int)placeholderIndexValue).append(marker).append(i + startIndex);
            }
            if (placeholderIndexList.get(placeholderIndexList.size() - 1) < sql.length()) {
                builder.append(sql, placeholderIndexList.get(placeholderIndexList.size() - 1) + 1, sql.length());
            }
            String formattedSql = builder.toString();
            if (log.isDebugEnabled()) {
                log.debug("Format placeholder based by index, with (" + placeholderDialect.getClass().getSimpleName() + ") => " + formattedSql);
            }
            return formattedSql;
        }
        List parameterMappings = boundSql.getParameterMappings();
        for (int i = 0; i < placeholderIndexList.size(); ++i) {
            Integer placeholderIndexValue = placeholderIndexList.get(i);
            builder.append(sql, i == 0 ? 0 : placeholderIndexList.get(i - 1) + 1, (int)placeholderIndexValue).append(marker);
            String parameterProperty = ((ParameterMapping)parameterMappings.get(i)).getProperty().replaceAll("\\.", "_");
            builder.append(parameterProperty);
        }
        if (placeholderIndexList.get(placeholderIndexList.size() - 1) < sql.length()) {
            builder.append(sql, placeholderIndexList.get(placeholderIndexList.size() - 1) + 1, sql.length());
        }
        String formattedSql = builder.toString();
        if (log.isDebugEnabled()) {
            log.debug("Format placeholder based on parameter name, with (" + placeholderDialect.getClass().getSimpleName() + ") => " + formattedSql);
        }
        return formattedSql;
    }

    protected List<Integer> extractJdbcPlaceholderIndex(String sql) {
        Matcher matcher = this.jdbcPlaceholderPattern.matcher(sql);
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int previous = -1;
        int result = -1;
        while (matcher.find()) {
            int start = matcher.start();
            if (previous < 0) {
                previous = start;
                result = start;
                continue;
            }
            if (start - previous == 1) {
                previous = start;
                if (result < 0) continue;
                result = -1;
                continue;
            }
            if (result >= 0) {
                indexList.add(result);
            }
            previous = start;
            result = start;
        }
        if (result > 0) {
            indexList.add(result);
        }
        return indexList;
    }
}

