/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.defaults;

import io.r2dbc.spi.ConnectionFactory;
import java.io.Closeable;
import java.util.Objects;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.ReactiveSqlSession;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.ReactiveSqlSessionFactory;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.connection.DefaultTransactionSupportConnectionFactory;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.defaults.DefaultReactiveSqlSession;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.delegate.R2dbcMybatisConfiguration;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.DefaultReactiveMybatisExecutor;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.ReactiveMybatisExecutor;

public class DefaultReactiveSqlSessionFactory
implements ReactiveSqlSessionFactory {
    private final R2dbcMybatisConfiguration configuration;
    private final ReactiveSqlSession reactiveSqlSession;

    private DefaultReactiveSqlSessionFactory(R2dbcMybatisConfiguration configuration, ReactiveMybatisExecutor reactiveMybatisExecutor) {
        this.configuration = configuration;
        this.reactiveSqlSession = new DefaultReactiveSqlSession(this.configuration, reactiveMybatisExecutor);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public ReactiveSqlSession openSession() {
        return this.reactiveSqlSession;
    }

    @Override
    public R2dbcMybatisConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void close() throws Exception {
        if (this.configuration.getConnectionFactory() instanceof Closeable) {
            Closeable closeableConnectionFactory = (Closeable)this.configuration.getConnectionFactory();
            closeableConnectionFactory.close();
        }
    }

    public static class Builder {
        private R2dbcMybatisConfiguration r2dbcMybatisConfiguration;
        private ConnectionFactory connectionFactory;
        private ReactiveMybatisExecutor reactiveMybatisExecutor;
        private boolean usingDefaultConnectionFactoryProxy = true;

        public Builder withR2dbcMybatisConfiguration(R2dbcMybatisConfiguration r2dbcMybatisConfiguration) {
            Objects.requireNonNull(r2dbcMybatisConfiguration, "R2dbcMybatisConfiguration Could not be null");
            this.r2dbcMybatisConfiguration = r2dbcMybatisConfiguration;
            return this;
        }

        public Builder withConnectionFactory(ConnectionFactory connectionFactory) {
            Objects.requireNonNull(connectionFactory, "ConnectionFactory Could not be null");
            this.connectionFactory = connectionFactory;
            return this;
        }

        public Builder withReactiveMybatisExecutor(ReactiveMybatisExecutor reactiveMybatisExecutor) {
            Objects.requireNonNull(reactiveMybatisExecutor, "ReactiveMybatisExecutor Could not be null");
            this.reactiveMybatisExecutor = reactiveMybatisExecutor;
            return this;
        }

        public Builder withDefaultConnectionFactoryProxy(boolean usingDefault) {
            this.usingDefaultConnectionFactoryProxy = usingDefault;
            return this;
        }

        public DefaultReactiveSqlSessionFactory build() {
            Objects.requireNonNull(this.r2dbcMybatisConfiguration, "R2dbcMybatisConfiguration Could not be null");
            if (Objects.isNull(this.r2dbcMybatisConfiguration.getConnectionFactory()) && Objects.isNull(this.connectionFactory)) {
                throw new IllegalArgumentException("ConnectionFactory Could not be null");
            }
            if (Objects.nonNull(this.connectionFactory)) {
                this.r2dbcMybatisConfiguration.setConnectionFactory(this.connectionFactory);
            }
            if (Objects.nonNull(this.reactiveMybatisExecutor)) {
                return new DefaultReactiveSqlSessionFactory(this.r2dbcMybatisConfiguration, this.reactiveMybatisExecutor);
            }
            if (this.usingDefaultConnectionFactoryProxy) {
                DefaultTransactionSupportConnectionFactory transactionSupportConnectionFactory = new DefaultTransactionSupportConnectionFactory(this.r2dbcMybatisConfiguration.getConnectionFactory());
                this.r2dbcMybatisConfiguration.setConnectionFactory(transactionSupportConnectionFactory);
                return new DefaultReactiveSqlSessionFactory(this.r2dbcMybatisConfiguration, new DefaultReactiveMybatisExecutor(this.r2dbcMybatisConfiguration));
            }
            return new DefaultReactiveSqlSessionFactory(this.r2dbcMybatisConfiguration, new DefaultReactiveMybatisExecutor(this.r2dbcMybatisConfiguration));
        }
    }
}

