/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.mapping.MappedStatement;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.delegate.R2dbcMybatisConfiguration;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.support.R2dbcStatementLog;

public class R2dbcStatementLogFactory {
    private final Map<String, R2dbcStatementLog> r2dbcStatementLogContainer = new HashMap<String, R2dbcStatementLog>();
    private final R2dbcMybatisConfiguration configuration;

    public R2dbcStatementLogFactory(R2dbcMybatisConfiguration r2dbcMybatisConfiguration) {
        this.configuration = r2dbcMybatisConfiguration;
    }

    public void initR2dbcStatementLog(MappedStatement mappedStatement) {
        String logId = mappedStatement.getId();
        if (this.configuration.getLogPrefix() != null) {
            logId = this.configuration.getLogPrefix() + mappedStatement.getId();
        }
        this.r2dbcStatementLogContainer.put(logId, new R2dbcStatementLog(mappedStatement.getStatementLog()));
    }

    public R2dbcStatementLog getR2dbcStatementLog(MappedStatement mappedStatement) {
        R2dbcStatementLog r2dbcStatementLog;
        String logId = mappedStatement.getId();
        if (this.configuration.getLogPrefix() != null) {
            logId = this.configuration.getLogPrefix() + mappedStatement.getId();
        }
        if (Objects.nonNull(r2dbcStatementLog = this.r2dbcStatementLogContainer.get(logId))) {
            return r2dbcStatementLog;
        }
        r2dbcStatementLog = new R2dbcStatementLog(mappedStatement.getStatementLog());
        this.r2dbcStatementLogContainer.put(logId, r2dbcStatementLog);
        return r2dbcStatementLog;
    }

    public Map<String, R2dbcStatementLog> getAllR2dbcStatementLog() {
        return Collections.unmodifiableMap(this.r2dbcStatementLogContainer);
    }
}

