/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.executor;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.Statement;
import java.sql.SQLException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.RowBounds;
import org.reactivestreams.Publisher;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.MybatisReactiveContextManager;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.delegate.R2dbcMybatisConfiguration;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.exception.R2dbcParameterException;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.AbstractReactiveMybatisExecutor;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.key.DefaultR2dbcKeyGenerator;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.key.KeyGeneratorType;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.key.NoKeyR2dbcKeyGenerator;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.key.R2dbcKeyGenerator;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.key.SelectR2dbcKeyGenerator;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.parameter.DelegateR2dbcParameterHandler;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.result.RowResultWrapper;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.result.handler.DefaultReactiveResultHandler;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.result.handler.ReactiveResultHandler;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.support.R2dbcStatementLog;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.support.ReactiveExecutorContext;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.support.ProxyInstanceFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultReactiveMybatisExecutor
extends AbstractReactiveMybatisExecutor {
    private static final Log log = LogFactory.getLog(DefaultReactiveMybatisExecutor.class);

    public DefaultReactiveMybatisExecutor(R2dbcMybatisConfiguration configuration) {
        super(configuration, configuration.getConnectionFactory());
    }

    @Override
    protected Mono<Integer> doUpdateWithConnection(Connection connection, MappedStatement mappedStatement, Object parameter) {
        return MybatisReactiveContextManager.currentContext().doOnNext(reactiveExecutorContext -> {
            if (log.isTraceEnabled()) {
                log.trace("Do update with connection from context : " + reactiveExecutorContext);
            }
        }).map(ReactiveExecutorContext::getR2dbcStatementLog).flatMap(r2dbcStatementLog -> {
            R2dbcKeyGenerator r2dbcKeyGenerator = this.getR2dbcKeyGenerator(mappedStatement);
            return r2dbcKeyGenerator.processSelectKey(KeyGeneratorType.SELECT_KEY_BEFORE, mappedStatement, parameter).flatMap(ignoreResult -> {
                String boundSql = mappedStatement.getBoundSql(parameter).getSql();
                boolean isReturnedGeneratedKeys = KeyGeneratorType.SIMPLE_RETURN.equals((Object)r2dbcKeyGenerator.keyGeneratorType());
                Statement statement = this.createStatementInternal(connection, boundSql, mappedStatement, parameter, RowBounds.DEFAULT, isReturnedGeneratedKeys, (R2dbcStatementLog)r2dbcStatementLog);
                return Mono.just((Object)isReturnedGeneratedKeys).filter(condition -> condition).flatMapMany(condition -> Flux.from((Publisher)statement.execute()).checkpoint("SQL: \"" + boundSql + "\" [DefaultReactiveExecutor]").take((long)mappedStatement.getKeyProperties().length, true).flatMap(result -> result.map((row, rowMetadata) -> {
                    RowResultWrapper rowResultWrapper = new RowResultWrapper((Row)row, (RowMetadata)rowMetadata, this.configuration);
                    return r2dbcKeyGenerator.processGeneratedKeyResult(rowResultWrapper, parameter);
                }))).switchIfEmpty((Publisher)Flux.from((Publisher)statement.execute()).checkpoint("SQL: \"" + boundSql + "\" [DefaultReactiveExecutor]").flatMap(result -> Mono.from((Publisher)result.getRowsUpdated()))).collect(Collectors.summingInt(Integer::intValue)).defaultIfEmpty((Object)0).doOnNext(r2dbcStatementLog::logUpdates).flatMap(totalUpdateRowCount -> r2dbcKeyGenerator.processSelectKey(KeyGeneratorType.SELECT_KEY_AFTER, mappedStatement, parameter).flatMap(ignore -> Mono.just((Object)totalUpdateRowCount)));
            });
        });
    }

    @Override
    protected <E> Flux<E> doQueryWithConnection(Connection connection, MappedStatement mappedStatement, Object parameter, RowBounds rowBounds) {
        return MybatisReactiveContextManager.currentContext().doOnNext(reactiveExecutorContext -> {
            if (log.isTraceEnabled()) {
                log.trace("Do query with connection from context : " + reactiveExecutorContext);
            }
        }).map(ReactiveExecutorContext::getR2dbcStatementLog).flatMapMany(r2dbcStatementLog -> {
            String boundSql = mappedStatement.getBoundSql(parameter).getSql();
            Statement statement = this.createStatementInternal(connection, boundSql, mappedStatement, parameter, rowBounds, false, (R2dbcStatementLog)r2dbcStatementLog);
            DefaultReactiveResultHandler reactiveResultHandler = new DefaultReactiveResultHandler(this.configuration, mappedStatement);
            return Flux.from((Publisher)statement.execute()).checkpoint("SQL: \"" + boundSql + "\" [DefaultReactiveExecutor]").skip((long)rowBounds.getOffset()).take((long)rowBounds.getLimit(), true).concatMap(result -> result.map((row, rowMetadata) -> {
                RowResultWrapper rowResultWrapper = new RowResultWrapper((Row)row, (RowMetadata)rowMetadata, this.configuration);
                return reactiveResultHandler.handleResult(rowResultWrapper);
            })).concatMap(Flux::fromIterable).filter(data -> !Objects.equals(data, ReactiveResultHandler.DEFERRED)).doOnComplete(() -> r2dbcStatementLog.logTotal(reactiveResultHandler.getResultRowTotalCount()));
        });
    }

    private Statement createStatementInternal(Connection connection, String boundSql, MappedStatement mappedStatement, Object parameter, RowBounds rowBounds, boolean returnedGeneratedKeys, R2dbcStatementLog r2dbcStatementLog) {
        r2dbcStatementLog.logSql(boundSql);
        StatementHandler handler = this.configuration.newStatementHandler(null, mappedStatement, parameter, rowBounds, null, null);
        ParameterHandler parameterHandler = handler.getParameterHandler();
        Statement statement = connection.createStatement(boundSql);
        if (returnedGeneratedKeys) {
            statement.returnGeneratedValues(mappedStatement.getKeyColumns());
        }
        ParameterHandler delegateParameterHandler = ProxyInstanceFactory.newInstanceOfInterfaces(ParameterHandler.class, () -> new DelegateR2dbcParameterHandler(this.configuration, parameterHandler, statement, r2dbcStatementLog), new Class[0]);
        try {
            delegateParameterHandler.setParameters(null);
        }
        catch (SQLException e) {
            throw new R2dbcParameterException(e);
        }
        return statement;
    }

    private R2dbcKeyGenerator getR2dbcKeyGenerator(MappedStatement mappedStatement) {
        boolean useJdbc3KeyGenerator;
        String[] keyColumns = mappedStatement.getKeyColumns();
        boolean hasKeyColumns = keyColumns != null && keyColumns.length != 0;
        KeyGenerator keyGenerator = mappedStatement.getKeyGenerator();
        boolean bl = useJdbc3KeyGenerator = keyGenerator instanceof Jdbc3KeyGenerator && hasKeyColumns;
        if (useJdbc3KeyGenerator) {
            return new DefaultR2dbcKeyGenerator(mappedStatement, this.configuration);
        }
        if (keyGenerator instanceof SelectKeyGenerator) {
            return new SelectR2dbcKeyGenerator((SelectKeyGenerator)keyGenerator, this.configuration, this);
        }
        return NoKeyR2dbcKeyGenerator.getInstance();
    }
}

