/*
 * Decompiled with CFR 0.152.
 */
package pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.key;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.ArrayUtil;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.ibatis.util.MapUtil;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.delegate.R2dbcMybatisConfiguration;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.key.R2dbcKeyGenerator;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.result.RowResultWrapper;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.result.TypeHandleContext;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.executor.result.handler.DelegateR2DbcResultRowDataHandler;
import pro.chenggang.project.reactive.mybatis.support.r2dbc.support.ProxyInstanceFactory;

public class DefaultR2dbcKeyGenerator
implements R2dbcKeyGenerator {
    private static final String SECOND_GENERIC_PARAM_NAME = "param2";
    private static final String MSG_TOO_MANY_KEYS = "Too many keys are generated. There are only %d target objects. You either specified a wrong 'keyProperty' or encountered a driver bug like #1523.";
    private final LongAdder resultRowCounter = new LongAdder();
    private final MappedStatement mappedStatement;
    private final R2dbcMybatisConfiguration r2DbcMybatisConfiguration;

    public DefaultR2dbcKeyGenerator(MappedStatement mappedStatement, R2dbcMybatisConfiguration r2DbcMybatisConfiguration) {
        this.mappedStatement = mappedStatement;
        this.r2DbcMybatisConfiguration = r2DbcMybatisConfiguration;
    }

    private static String nameOfSingleParam(Map<String, ?> paramMap) {
        return paramMap.keySet().iterator().next();
    }

    private static List<?> collectionize(Object param) {
        if (param instanceof Collection) {
            return new ArrayList((Collection)param);
        }
        if (param instanceof Object[]) {
            return Arrays.asList((Object[])param);
        }
        return Arrays.asList(param);
    }

    @Override
    public Integer getResultRowCount() {
        return this.resultRowCounter.intValue();
    }

    @Override
    public Integer handleKeyResult(RowResultWrapper rowResultWrapper, Object parameter) {
        this.assignKeys(this.r2DbcMybatisConfiguration, rowResultWrapper, this.mappedStatement.getKeyProperties(), parameter);
        this.resultRowCounter.increment();
        return 1;
    }

    private void assignKeys(R2dbcMybatisConfiguration configuration, RowResultWrapper rowResultWrapper, String[] keyProperties, Object parameter) {
        if (parameter instanceof MapperMethod.ParamMap) {
            this.assignKeysToParamMap(configuration, rowResultWrapper, keyProperties, (Map)parameter);
        } else if (parameter instanceof ArrayList && !((ArrayList)parameter).isEmpty() && ((ArrayList)parameter).get(0) instanceof MapperMethod.ParamMap) {
            this.assignKeysToParamMapList(configuration, rowResultWrapper, keyProperties, (ArrayList)parameter);
        } else {
            this.assignKeysToParam(configuration, rowResultWrapper, keyProperties, parameter);
        }
    }

    private void assignKeysToParam(R2dbcMybatisConfiguration configuration, RowResultWrapper rowResultWrapper, String[] keyProperties, Object parameter) {
        List<?> params = DefaultR2dbcKeyGenerator.collectionize(parameter);
        if (params.isEmpty()) {
            return;
        }
        int i = this.resultRowCounter.intValue();
        if (params.size() <= i) {
            throw new ExecutorException(String.format(MSG_TOO_MANY_KEYS, params.size()));
        }
        KeyAssigner keyAssigner = new KeyAssigner(configuration, i + 1, null, keyProperties[i]);
        keyAssigner.assign(rowResultWrapper, params.get(i));
    }

    private void assignKeysToParamMapList(R2dbcMybatisConfiguration configuration, RowResultWrapper rowResultWrapper, String[] keyProperties, ArrayList<MapperMethod.ParamMap<?>> paramMapList) {
        int i = this.resultRowCounter.intValue();
        if (paramMapList.size() <= i) {
            throw new ExecutorException(String.format(MSG_TOO_MANY_KEYS, paramMapList.size()));
        }
        ArrayList<KeyAssigner> assignerList = new ArrayList<KeyAssigner>();
        MapperMethod.ParamMap<?> paramMap = paramMapList.get(i);
        for (int j = 0; j < keyProperties.length; ++j) {
            assignerList.add(this.getAssignerForParamMap(configuration, j + 1, (Map<String, ?>)paramMap, keyProperties[j], keyProperties, false).getValue());
        }
        assignerList.forEach(x -> x.assign(rowResultWrapper, paramMap));
    }

    private void assignKeysToParamMap(R2dbcMybatisConfiguration configuration, RowResultWrapper rowResultWrapper, String[] keyProperties, Map<String, ?> paramMap) {
        int i;
        if (paramMap.isEmpty()) {
            return;
        }
        HashMap assignerMap = new HashMap();
        for (i = 0; i < keyProperties.length; ++i) {
            Map.Entry<String, KeyAssigner> entry = this.getAssignerForParamMap(configuration, i + 1, paramMap, keyProperties[i], keyProperties, true);
            Map.Entry iteratorPair = (Map.Entry)MapUtil.computeIfAbsent(assignerMap, (Object)entry.getKey(), k -> MapUtil.entry(DefaultR2dbcKeyGenerator.collectionize(paramMap.get(k)), new ArrayList()));
            ((List)iteratorPair.getValue()).add(entry.getValue());
        }
        i = this.resultRowCounter.intValue();
        for (Map.Entry pair : assignerMap.values()) {
            if (((List)pair.getKey()).size() <= i) {
                throw new ExecutorException(String.format(MSG_TOO_MANY_KEYS, paramMap.size()));
            }
            Object param = ((List)pair.getKey()).get(i);
            ((List)pair.getValue()).forEach(x -> x.assign(rowResultWrapper, param));
        }
    }

    private Map.Entry<String, KeyAssigner> getAssignerForParamMap(R2dbcMybatisConfiguration config, int columnPosition, Map<String, ?> paramMap, String keyProperty, String[] keyProperties, boolean omitParamName) {
        Set<String> keySet = paramMap.keySet();
        boolean singleParam = !keySet.contains(SECOND_GENERIC_PARAM_NAME);
        int firstDot = keyProperty.indexOf(46);
        if (firstDot == -1) {
            if (singleParam) {
                return this.getAssignerForSingleParam(config, columnPosition, paramMap, keyProperty, omitParamName);
            }
            throw new ExecutorException("Could not determine which parameter to assign generated keys to. Note that when there are multiple parameters, 'keyProperty' must include the parameter name (e.g. 'param.id'). Specified key properties are " + ArrayUtil.toString((Object)keyProperties) + " and available parameters are " + keySet);
        }
        String paramName = keyProperty.substring(0, firstDot);
        if (keySet.contains(paramName)) {
            String argParamName = omitParamName ? null : paramName;
            String argKeyProperty = keyProperty.substring(firstDot + 1);
            return MapUtil.entry((Object)paramName, (Object)new KeyAssigner(config, columnPosition, argParamName, argKeyProperty));
        }
        if (singleParam) {
            return this.getAssignerForSingleParam(config, columnPosition, paramMap, keyProperty, omitParamName);
        }
        throw new ExecutorException("Could not find parameter '" + paramName + "'. Note that when there are multiple parameters, 'keyProperty' must include the parameter name (e.g. 'param.id'). Specified key properties are " + ArrayUtil.toString((Object)keyProperties) + " and available parameters are " + keySet);
    }

    private Map.Entry<String, KeyAssigner> getAssignerForSingleParam(R2dbcMybatisConfiguration r2DbcMybatisConfiguration, int columnPosition, Map<String, ?> paramMap, String keyProperty, boolean omitParamName) {
        String singleParamName = DefaultR2dbcKeyGenerator.nameOfSingleParam(paramMap);
        String argParamName = omitParamName ? null : singleParamName;
        return MapUtil.entry((Object)singleParamName, (Object)new KeyAssigner(r2DbcMybatisConfiguration, columnPosition, argParamName, keyProperty));
    }

    private class KeyAssigner {
        private final R2dbcMybatisConfiguration r2DbcMybatisConfiguration;
        private final TypeHandlerRegistry typeHandlerRegistry;
        private final int columnPosition;
        private final String paramName;
        private final String propertyName;
        private final TypeHandler delegatedTypeHandler;
        private TypeHandler<?> typeHandler;

        protected KeyAssigner(R2dbcMybatisConfiguration r2DbcMybatisConfiguration, int columnPosition, String paramName, String propertyName) {
            this.r2DbcMybatisConfiguration = r2DbcMybatisConfiguration;
            this.typeHandlerRegistry = r2DbcMybatisConfiguration.getTypeHandlerRegistry();
            this.columnPosition = columnPosition;
            this.paramName = paramName;
            this.propertyName = propertyName;
            this.delegatedTypeHandler = this.initDelegateTypeHandler();
        }

        private TypeHandler initDelegateTypeHandler() {
            return ProxyInstanceFactory.newInstanceOfInterfaces(TypeHandler.class, () -> new DelegateR2DbcResultRowDataHandler(this.r2DbcMybatisConfiguration.getNotSupportedDataTypes(), this.r2DbcMybatisConfiguration.getR2dbcTypeHandlerAdapterRegistry().getR2dbcTypeHandlerAdapters()), TypeHandleContext.class);
        }

        protected void assign(RowResultWrapper rowResultWrapper, Object param) {
            if (this.paramName != null) {
                param = ((MapperMethod.ParamMap)param).get((Object)this.paramName);
            }
            MetaObject metaParam = this.r2DbcMybatisConfiguration.newMetaObject(param);
            try {
                if (this.typeHandler == null) {
                    if (metaParam.hasSetter(this.propertyName)) {
                        Class propertyType = metaParam.getSetterType(this.propertyName);
                        this.typeHandler = this.typeHandlerRegistry.getTypeHandler(propertyType);
                    } else {
                        throw new ExecutorException("No setter found for the keyProperty '" + this.propertyName + "' in '" + metaParam.getOriginalObject().getClass().getName() + "'.");
                    }
                }
                if (this.typeHandler != null) {
                    ((TypeHandleContext)this.delegatedTypeHandler).contextWith(this.typeHandler, rowResultWrapper);
                    ResultSet resultSet = null;
                    Object value = this.delegatedTypeHandler.getResult(resultSet, this.columnPosition);
                    metaParam.setValue(this.propertyName, value);
                }
            }
            catch (SQLException e) {
                throw new ExecutorException("Error getting generated key or setting result to parameter object. Cause: " + e, (Throwable)e);
            }
        }
    }
}

